/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jbang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.awaitility.core.ConditionTimeoutException;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.jbang.ProcessOutputListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessAndOutput {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessAndOutput.class);
    private final Process process;
    private String output = "";
    private final ProcessOutputListener outputListener;
    private BufferedReader reader;

    ProcessAndOutput(Process process) {
        this(process, null, null);
    }

    ProcessAndOutput(Process process, ProcessOutputListener outputListener) {
        this(process, null, outputListener);
    }

    ProcessAndOutput(Process process, File outputFile) {
        this(process, outputFile, null);
    }

    ProcessAndOutput(Process process, File outputFile, ProcessOutputListener outputListener) {
        this.process = process;
        this.outputListener = outputListener;
        if (outputFile != null) {
            try {
                this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(outputFile)));
            }
            catch (FileNotFoundException e) {
                throw new CitrusRuntimeException(String.format("Failed to access process output file %s", outputFile.getName()), (Throwable)e);
            }
        } else {
            this.reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public String getOutput() {
        if (this.process.isAlive()) {
            this.readChunk();
        } else if (this.reader != null) {
            this.readAllAndClose();
        }
        return this.output;
    }

    public String waitFor() throws InterruptedException {
        if (this.reader != null) {
            this.readAllAndClose();
        }
        this.process.waitFor();
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readAllAndClose() {
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                builder.append(line).append(System.lineSeparator());
                if (this.outputListener == null) continue;
                this.outputListener.handle(line + System.lineSeparator());
            }
            if (builder.isEmpty()) return;
            this.output = this.output + builder;
            return;
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to get JBang process output", (Throwable)e);
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                LOG.debug("Failed to close JBang process output reader", (Throwable)e);
            }
            finally {
                this.reader = null;
            }
        }
    }

    private void readChunk() {
        int maxRead = 100;
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            for (int read = 1; read <= maxRead && this.reader.ready() && (line = this.reader.readLine()) != null; ++read) {
                builder.append(line).append(System.lineSeparator());
                if (this.outputListener == null) continue;
                this.outputListener.handle(line + System.lineSeparator());
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to get JBang process output", (Throwable)e);
        }
        if (!builder.isEmpty()) {
            this.output = this.output == null ? builder.toString() : this.output + builder.toString().stripTrailing();
        }
    }

    public Long getProcessId() {
        return this.process.pid();
    }

    public List<Long> getDescendants() {
        try {
            return this.process.descendants().peek(p -> {
                if (LOG.isDebugEnabled()) {
                    LOG.info(String.format("Found descendant process (pid:%d) for process '%d'", p.pid(), this.getProcessId()));
                }
            }).map(ProcessHandle::pid).collect(Collectors.toList());
        }
        catch (SecurityException | UnsupportedOperationException | ConditionTimeoutException e) {
            return Collections.emptyList();
        }
    }
}

