/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jbang;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.jbang.JBangSettings;
import org.citrusframework.jbang.JBangSupport;
import org.citrusframework.jbang.ProcessAndOutput;
import org.citrusframework.jbang.ProcessOutputListener;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitrusJBang {
    private static final Logger logger = LoggerFactory.getLogger(CitrusJBang.class);
    private final JBangSupport app;
    private String version;

    public CitrusJBang() {
        this(null);
    }

    public CitrusJBang(String app) {
        this.app = JBangSupport.jbang().app(Optional.ofNullable(app).orElseGet(JBangSettings::getApp));
        String version = this.version();
        if (logger.isDebugEnabled()) {
            logger.debug("Citrus JBang version: " + version);
        }
    }

    public static CitrusJBang citrus() {
        return new CitrusJBang();
    }

    public CitrusJBang workingDir(Path workingDir) {
        this.app.workingDir(workingDir);
        return this;
    }

    public CitrusJBang withSystemProperty(String name, String value) {
        this.app.withSystemProperty(name, value);
        return this;
    }

    public CitrusJBang withSystemProperties(Map<String, String> systemProperties) {
        this.app.withSystemProperties(systemProperties);
        return this;
    }

    public CitrusJBang withEnv(String name, String value) {
        this.app.withEnv(name, value);
        return this;
    }

    public CitrusJBang withEnvs(Map<String, String> envVars) {
        this.app.withEnvs(envVars);
        return this;
    }

    public CitrusJBang withClasspathEntries(List<String> entries) {
        this.app.withClasspathEntries(entries);
        return this;
    }

    public CitrusJBang addToClasspath(String path) {
        this.app.addToClasspath(path);
        return this;
    }

    public CitrusJBang withOutputListener(ProcessOutputListener outputListener) {
        this.app.withOutputListener(outputListener);
        return this;
    }

    public CitrusJBang withVersion(String version) {
        this.app.withSystemProperty("citrus.jbang.version", version);
        return this;
    }

    public ProcessAndOutput run(String command, String ... args) {
        return this.app.run(command, args);
    }

    public JBangSupport app() {
        return this.app;
    }

    public Agent agent() {
        return new Agent();
    }

    public void run(String fileNameOrDir, Map<String, Object> args) {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(fileNameOrDir);
        args.entrySet().stream().map(entry -> "%s=%s".formatted(entry.getKey(), entry.getValue())).forEach(argsList::add);
        ProcessAndOutput pao = this.app.run("run", argsList);
        if (pao.getProcess().exitValue() != 0) {
            throw new CitrusRuntimeException("Test run failed - process exited with exit code: " + pao.getProcess().exitValue());
        }
    }

    public void stop(Long pid) {
        ProcessHandle.of(pid).ifPresent(ph -> {
            if (ph.destroyForcibly()) {
                logger.debug("Stopped Citrus agent process (pid: %s)".formatted(pid));
            } else {
                logger.warn("Failed to stop Citrus agent process (pid: %s)".formatted(pid));
            }
        });
    }

    public String ls() {
        ProcessAndOutput p = this.app.run("ls", new String[0]);
        return p.getOutput();
    }

    public Map<String, String> get(Long pid) {
        HashMap<String, String> hashMap;
        HashMap<String, String> properties = new HashMap<String, String>();
        String output = this.ls();
        if (output.isBlank()) {
            return properties;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(output.getBytes(StandardCharsets.UTF_8))));
        try {
            String line = reader.readLine();
            ArrayList<String> names = new ArrayList<String>(Arrays.asList(line.trim().split("\\s+")));
            while ((line = reader.readLine()) != null) {
                ArrayList<String> values = new ArrayList<String>(Arrays.asList(line.trim().split("\\s+")));
                if (values.isEmpty() || !((String)values.get(0)).equals(String.valueOf(pid))) continue;
                for (int i = 0; i < names.size(); ++i) {
                    if (i < values.size()) {
                        properties.put((String)names.get(i), (String)values.get(i));
                        continue;
                    }
                    properties.put((String)names.get(i), "");
                }
            }
            hashMap = properties;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to get integration details from JBang", (Throwable)e);
            }
        }
        reader.close();
        return hashMap;
    }

    public Map<String, String> get(String name) {
        return this.getAll().stream().filter(row -> row.getOrDefault("NAME", "").equals(name)).findFirst().orElseGet(Collections::emptyMap);
    }

    public List<Map<String, String>> getAll() {
        ArrayList<Map<String, String>> arrayList;
        ArrayList<Map<String, String>> processes = new ArrayList<Map<String, String>>();
        String output = this.ls();
        if (output.isBlank()) {
            return processes;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(output.getBytes(StandardCharsets.UTF_8))));
        try {
            String line = reader.readLine();
            ArrayList<String> names = new ArrayList<String>(Arrays.asList(line.trim().split("\\s+")));
            while ((line = reader.readLine()) != null) {
                HashMap<String, String> properties = new HashMap<String, String>();
                ArrayList<String> values = new ArrayList<String>(Arrays.asList(line.trim().split("\\s+")));
                for (int i = 0; i < names.size(); ++i) {
                    if (i < values.size()) {
                        properties.put((String)names.get(i), (String)values.get(i));
                        continue;
                    }
                    properties.put((String)names.get(i), "");
                }
                processes.add(properties);
            }
            arrayList = processes;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to list Citrus processes from JBang", (Throwable)e);
            }
        }
        reader.close();
        return arrayList;
    }

    public String version() {
        if (!StringUtils.hasText((String)this.version)) {
            ProcessAndOutput p = this.app.run("--version", new String[0]);
            this.version = p.getOutput();
        }
        return this.version;
    }

    public class Agent {
        private boolean dumpOutput = false;

        public Agent dumpOutput(boolean enabled) {
            this.dumpOutput = enabled;
            return this;
        }

        public ProcessAndOutput start() {
            ProcessAndOutput pao;
            if (this.dumpOutput) {
                Path workDir = Optional.ofNullable(CitrusJBang.this.app.getWorkingDir()).orElseGet(JBangSettings::getWorkDir);
                File outputFile = workDir.resolve("citrus-agent-output.txt").toFile();
                pao = CitrusJBang.this.app.runAsync("agent", outputFile, "start");
            } else {
                pao = CitrusJBang.this.app.runAsync("agent", "start");
            }
            if (!pao.getProcess().isAlive() && pao.getProcess().exitValue() != 0) {
                logger.error("Failed to start Citrus agent - exit value %d %n%s".formatted(pao.getProcess().exitValue(), pao.getOutput()));
                throw new CitrusRuntimeException("Failed to start Citrus agent - exit value %d".formatted(pao.getProcess().exitValue()));
            }
            return pao;
        }

        public Long stop() {
            return this.stop("citrus-agent");
        }

        public Long stop(String serverName) {
            Long pid = Optional.of(CitrusJBang.this.get(serverName).getOrDefault("PID", "")).filter(StringUtils::hasText).map(Long::parseLong).orElse(0L);
            if (pid > 0L) {
                CitrusJBang.this.stop(pid);
                return pid;
            }
            throw new CitrusRuntimeException("Failed to find JBang Citrus agent process");
        }
    }
}

