/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.servlet;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.citrusframework.http.servlet.GzipHttpServletRequestWrapper;
import org.citrusframework.http.servlet.GzipHttpServletResponseWrapper;
import org.springframework.web.filter.OncePerRequestFilter;

public class GzipServletFilter
extends OncePerRequestFilter {
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Object filteredRequest = request;
        Object filteredResponse = response;
        if (this.isGzipEncoding(request.getHeader("Content-Encoding"))) {
            filteredRequest = new GzipHttpServletRequestWrapper(request);
        }
        if (this.isGzipEncoding(request.getHeader("Accept-Encoding"))) {
            filteredResponse = new GzipHttpServletResponseWrapper(response);
        }
        filterChain.doFilter((ServletRequest)filteredRequest, (ServletResponse)filteredResponse);
        if (filteredResponse instanceof GzipHttpServletResponseWrapper) {
            GzipHttpServletResponseWrapper gzipHttpServletResponseWrapper = (GzipHttpServletResponseWrapper)((Object)filteredResponse);
            gzipHttpServletResponseWrapper.finish();
        }
    }

    private boolean isGzipEncoding(String contentEncoding) {
        return contentEncoding != null && contentEncoding.contains("gzip");
    }
}

