/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.actions;

import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.http.actions.HttpClientActionBuilder;
import org.citrusframework.http.actions.HttpServerActionBuilder;
import org.citrusframework.http.client.HttpClient;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.ObjectHelper;

public class HttpActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<TestAction>,
ReferenceResolverAware {
    private ReferenceResolver referenceResolver;
    private TestActionBuilder<?> delegate;

    public static HttpActionBuilder http() {
        return new HttpActionBuilder();
    }

    public HttpClientActionBuilder client(HttpClient httpClient) {
        HttpClientActionBuilder clientActionBuilder = new HttpClientActionBuilder((Endpoint)httpClient).withReferenceResolver(this.referenceResolver);
        this.delegate = clientActionBuilder;
        return clientActionBuilder;
    }

    public HttpClientActionBuilder client(String httpClient) {
        HttpClientActionBuilder clientActionBuilder = new HttpClientActionBuilder(httpClient).withReferenceResolver(this.referenceResolver);
        this.delegate = clientActionBuilder;
        return clientActionBuilder;
    }

    public HttpServerActionBuilder server(Endpoint endpoint) {
        HttpServerActionBuilder serverActionBuilder = new HttpServerActionBuilder(endpoint).withReferenceResolver(this.referenceResolver);
        this.delegate = serverActionBuilder;
        return serverActionBuilder;
    }

    public HttpServerActionBuilder server(String httpServer) {
        HttpServerActionBuilder serverActionBuilder = new HttpServerActionBuilder(httpServer).withReferenceResolver(this.referenceResolver);
        this.delegate = serverActionBuilder;
        return serverActionBuilder;
    }

    public HttpActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    public TestAction build() {
        ObjectHelper.assertNotNull(this.delegate, (String)"Missing delegate action to build");
        return this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (referenceResolver == null) {
            this.referenceResolver = referenceResolver;
            if (this.delegate instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)this.delegate).setReferenceResolver(referenceResolver);
            }
        }
    }
}

