/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.util.Arrays;

public class TestFlowReporterSettings {
    private static final String REPORT_OUTPUT_PROPERTY = "citrus.test.flow.report.output";
    private static final String REPORT_OUTPUT_ENV = "CITRUS_TEST_FLOW_REPORT_OUTPUT";
    private static final String REPORT_OUTPUT_DEFAULT = "json";
    private static final String REPORT_ENABLED_PROPERTY = "citrus.test.flow.report.enabled";
    private static final String REPORT_ENABLED_ENV = "CITRUS_TEST_FLOW_REPORT_ENABLED";
    private static final String REPORT_ENABLED_DEFAULT = Boolean.TRUE.toString();

    private TestFlowReporterSettings() {
    }

    public static String getReportOutput() {
        return System.getProperty(REPORT_OUTPUT_PROPERTY, System.getenv(REPORT_OUTPUT_ENV) != null ? System.getenv(REPORT_OUTPUT_ENV) : REPORT_OUTPUT_DEFAULT);
    }

    public static boolean isJsonReport() {
        return TestFlowReporterSettings.isReportEnabled(REPORT_OUTPUT_DEFAULT);
    }

    public static boolean isYamlReport() {
        return TestFlowReporterSettings.isReportEnabled("yaml");
    }

    public static boolean isReportEnabled(String type) {
        if (type.equalsIgnoreCase(TestFlowReporterSettings.getReportOutput())) {
            return true;
        }
        if (TestFlowReporterSettings.getReportOutput().contains(",")) {
            return Arrays.stream(TestFlowReporterSettings.getReportOutput().split(",")).anyMatch(s -> s.trim().equals(type));
        }
        return false;
    }

    public static boolean isReportEnabled() {
        return Boolean.parseBoolean(System.getProperty(REPORT_ENABLED_PROPERTY, System.getenv(REPORT_ENABLED_ENV) != null ? System.getenv(REPORT_ENABLED_ENV) : REPORT_ENABLED_DEFAULT));
    }
}

