/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message.correlation;

import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.correlation.CorrelationManager;
import org.citrusframework.message.correlation.DefaultObjectStore;
import org.citrusframework.message.correlation.ObjectStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCorrelationManager<T>
implements CorrelationManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCorrelationManager.class);
    private ObjectStore<T> objectStore = new DefaultObjectStore();

    public void saveCorrelationKey(String correlationKeyName, String correlationKey, TestContext context) {
        logger.debug("Saving correlation key for '{}'", (Object)correlationKeyName);
        context.setVariable(correlationKeyName, (Object)correlationKey);
    }

    public String getCorrelationKey(String correlationKeyName, TestContext context) {
        logger.debug("Get correlation key for '{}'", (Object)correlationKeyName);
        if (context.getVariables().containsKey(correlationKeyName)) {
            return context.getVariable(correlationKeyName);
        }
        throw new CitrusRuntimeException(String.format("Failed to get correlation key for '%s'", correlationKeyName));
    }

    public void store(String correlationKey, T object) {
        if (object == null) {
            logger.warn("Ignore correlated null object for '{}'", (Object)correlationKey);
            return;
        }
        logger.debug("Saving correlated object for '{}'", (Object)correlationKey);
        this.objectStore.add(correlationKey, object);
    }

    public T find(String correlationKey, long timeout) {
        logger.debug("Finding correlated object for '{}'", (Object)correlationKey);
        return (T)this.objectStore.remove(correlationKey);
    }

    public void setObjectStore(ObjectStore<T> store) {
        this.objectStore = store;
    }

    public ObjectStore<T> getObjectStore() {
        return this.objectStore;
    }
}

