/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.parameter;

import java.util.ArrayList;
import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.ParameterizedFunction;
import org.citrusframework.yaml.SchemaProperty;

public class StringParameters
implements ParameterizedFunction.FunctionParameters {
    private final List<String> values = new ArrayList<String>();
    private boolean allowEmpty = false;

    public void configure(List<String> parameterList, TestContext context) {
        if (!this.allowEmpty && (parameterList == null || parameterList.isEmpty())) {
            throw new InvalidFunctionUsageException("Function parameters must not be empty");
        }
        this.setValues(parameterList);
    }

    public StringParameters withAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
        return this;
    }

    public List<String> getValues() {
        return this.values;
    }

    @SchemaProperty(required=true, description="The list of values to evaluate.")
    public void setValues(List<String> values) {
        this.values.addAll(values);
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }
}

