/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.parameter;

import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.ParameterizedFunction;
import org.citrusframework.yaml.SchemaProperty;

public class StringParameter
implements ParameterizedFunction.FunctionParameters {
    private String value;
    boolean allowEmpty = true;
    boolean useRawValue = false;

    public void configure(List<String> parameterList, TestContext context) {
        if (parameterList == null || parameterList.isEmpty()) {
            throw new InvalidFunctionUsageException("Function parameters must not be empty");
        }
        if (parameterList.size() != 1) {
            throw new InvalidFunctionUsageException("Too many function parameters");
        }
        if (!this.allowEmpty && parameterList.get(0).isEmpty()) {
            throw new InvalidFunctionUsageException("The input must be a single non-empty string");
        }
        if (this.useRawValue) {
            this.setValue(parameterList.get(0));
        } else {
            this.setValue(context.resolveDynamicValue(parameterList.get(0)));
        }
    }

    public StringParameter withAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
        return this;
    }

    public StringParameter withUseRawValue(boolean useRawValue) {
        this.useRawValue = useRawValue;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    @SchemaProperty(required=true, description="The value to evaluate.")
    public void setValue(String value) {
        this.value = value;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public boolean isUseRawValue() {
        return this.useRawValue;
    }

    public void setUseRawValue(boolean useRawValue) {
        this.useRawValue = useRawValue;
    }
}

