/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.parameter;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.DoubleStream;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.ParameterizedFunction;
import org.citrusframework.yaml.SchemaProperty;

public class NumericParameters
implements ParameterizedFunction.FunctionParameters {
    private final List<String> values = new ArrayList<String>();

    public void configure(List<String> parameterList, TestContext context) {
        if (parameterList == null || parameterList.isEmpty()) {
            throw new InvalidFunctionUsageException("Function parameters must not be empty");
        }
        this.setValues(context.resolveDynamicValuesInList(parameterList));
    }

    public DoubleStream asDoubleStream() {
        return this.getValues().stream().mapToDouble(Double::parseDouble);
    }

    public List<String> getValues() {
        return this.values;
    }

    @SchemaProperty(required=true, description="The list of values to evaluate. Must be numeric values or test variables that evaluate to numeric values.")
    public void setValues(List<String> values) {
        this.values.addAll(values);
    }
}

