/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.ParameterizedFunction;
import org.citrusframework.yaml.SchemaProperty;

public class TranslateFunction
implements ParameterizedFunction<Parameters> {
    public String execute(Parameters params, TestContext context) {
        return params.getValue().replaceAll(params.getRegex(), params.getReplacement());
    }

    public Parameters getParameters() {
        return new Parameters();
    }

    public static class Parameters
    implements ParameterizedFunction.FunctionParameters {
        private String value;
        private String regex;
        private String replacement;

        public void configure(List<String> parameterList, TestContext context) {
            if (parameterList == null || parameterList.size() < 3) {
                throw new InvalidFunctionUsageException("Function parameters not set correctly");
            }
            this.value = parameterList.get(0);
            this.regex = parameterList.get(1);
            this.replacement = parameterList.get(2);
        }

        public String getValue() {
            return this.value;
        }

        @SchemaProperty(required=true, description="The value to evaluate.")
        public void setValue(String value) {
            this.value = value;
        }

        public String getRegex() {
            return this.regex;
        }

        @SchemaProperty(required=true, description="The regular expression to evaluate.")
        public void setRegex(String regex) {
            this.regex = regex;
        }

        public String getReplacement() {
            return this.replacement;
        }

        @SchemaProperty(required=true, description="The transform replacement.")
        public void setReplacement(String replacement) {
            this.replacement = replacement;
        }
    }
}

