/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.util.List;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.ParameterizedFunction;
import org.citrusframework.yaml.SchemaProperty;

public class SystemPropertyFunction
implements ParameterizedFunction<Parameters> {
    public String execute(Parameters params, TestContext context) {
        String propertyName = params.getPropertyName();
        Optional<String> defaultValue = Optional.ofNullable(params.getDefaultValue());
        return Optional.ofNullable(System.getProperty(propertyName)).orElseGet(() -> (String)defaultValue.orElseThrow(() -> new CitrusRuntimeException(String.format("Failed to resolve system property '%s'", propertyName))));
    }

    public Parameters getParameters() {
        return new Parameters();
    }

    public static class Parameters
    implements ParameterizedFunction.FunctionParameters {
        private String propertyName;
        private String defaultValue;

        public void configure(List<String> parameterList, TestContext context) {
            if (parameterList == null || parameterList.isEmpty()) {
                throw new InvalidFunctionUsageException("Function parameters must not be empty");
            }
            this.setPropertyName(parameterList.get(0));
            if (parameterList.size() > 1) {
                this.defaultValue = context.replaceDynamicContentInString(parameterList.get(1));
            }
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        @SchemaProperty(required=true, description="The system property name.")
        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        @SchemaProperty(description="The default value when system property is not set.")
        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }
    }
}

