/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

public final class DateFunctionHelper {
    private DateFunctionHelper() {
    }

    static void applyDateOffset(Calendar calendar, String offsetString) {
        calendar.add(1, DateFunctionHelper.getDateValueOffset(offsetString, 'y'));
        calendar.add(2, DateFunctionHelper.getDateValueOffset(offsetString, 'M'));
        calendar.add(6, DateFunctionHelper.getDateValueOffset(offsetString, 'd'));
        calendar.add(10, DateFunctionHelper.getDateValueOffset(offsetString, 'h'));
        calendar.add(12, DateFunctionHelper.getDateValueOffset(offsetString, 'm'));
        calendar.add(13, DateFunctionHelper.getDateValueOffset(offsetString, 's'));
    }

    static int getDateValueOffset(String offsetString, char c) {
        ArrayList<Character> charList = new ArrayList<Character>();
        int index = offsetString.indexOf(c);
        if (index != -1) {
            for (int i = index - 1; i >= 0; --i) {
                if (!Character.isDigit(offsetString.charAt(i))) {
                    StringBuilder offsetValue = new StringBuilder();
                    offsetValue.append("0");
                    for (Character character : charList) {
                        offsetValue.append(character);
                    }
                    if (offsetString.charAt(i) == '-') {
                        return Integer.parseInt("-" + offsetValue);
                    }
                    return Integer.parseInt(offsetValue.toString());
                }
                charList.add(0, Character.valueOf(offsetString.charAt(i)));
            }
        }
        return 0;
    }

    static SimpleDateFormat getDefaultDateFormat() {
        return new SimpleDateFormat("dd.MM.yyyy");
    }
}

