/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.ParameterizedFunction;
import org.citrusframework.functions.core.DateFunctionHelper;
import org.citrusframework.util.StringUtils;
import org.citrusframework.yaml.SchemaProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeDateFunction
implements ParameterizedFunction<Parameters> {
    private static final Logger logger = LoggerFactory.getLogger(ChangeDateFunction.class);
    private final CalendarProvider calendarProvider = new CalendarProvider();

    public String execute(Parameters params, TestContext context) {
        String result;
        Calendar calendar = this.calendarProvider.getInstance();
        SimpleDateFormat dateFormat = StringUtils.hasText(params.getDateFormat()) ? new SimpleDateFormat(params.getDateFormat()) : DateFunctionHelper.getDefaultDateFormat();
        try {
            calendar.setTime(dateFormat.parse(params.getValue()));
        }
        catch (ParseException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
        if (StringUtils.hasText(params.getOffset())) {
            DateFunctionHelper.applyDateOffset(calendar, params.getOffset());
        }
        try {
            result = dateFormat.format(calendar.getTime());
        }
        catch (RuntimeException e) {
            logger.error("Error while formatting dateParameter value ", (Throwable)e);
            throw new CitrusRuntimeException((Throwable)e);
        }
        return result;
    }

    public Parameters getParameters() {
        return new Parameters();
    }

    static class CalendarProvider {
        private CalendarProvider() {
        }

        Calendar getInstance() {
            return Calendar.getInstance();
        }
    }

    public static class Parameters
    implements ParameterizedFunction.FunctionParameters {
        private String value;
        private String offset;
        private String dateFormat;

        public void configure(List<String> parameterList, TestContext context) {
            if (parameterList == null || parameterList.isEmpty()) {
                throw new InvalidFunctionUsageException("Function parameters must not be empty");
            }
            this.setValue(context.resolveDynamicValue(parameterList.get(0)));
            if (parameterList.size() > 1) {
                this.setOffset(parameterList.get(1));
            }
            if (parameterList.size() > 2) {
                this.setDateFormat(parameterList.get(2));
            }
        }

        public String getValue() {
            return this.value;
        }

        @SchemaProperty(required=true, description="The value to evaluate.")
        public void setValue(String value) {
            this.value = value;
        }

        public String getOffset() {
            return this.offset;
        }

        @SchemaProperty(description="The date offset.")
        public void setOffset(String offset) {
            this.offset = offset;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        @SchemaProperty(description="The date format string.")
        public void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }
    }
}

