/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.Function;

public class AdvancedRandomNumberFunction
implements Function {
    private static final BigDecimal DEFAULT_MAX_VALUE = new BigDecimal(1000000);
    private static final BigDecimal DEFAULT_MIN_VALUE = DEFAULT_MAX_VALUE.negate();

    public String execute(List<String> parameterList, TestContext context) {
        BigDecimal maxValue;
        if (parameterList == null) {
            throw new InvalidFunctionUsageException("Function parameters must not be null.");
        }
        int decimalPlaces = this.getParameter(parameterList, 0, Integer.class, Integer::parseInt, 2);
        if (decimalPlaces < 0) {
            throw new InvalidFunctionUsageException("Decimal places must be a non-negative integer value.");
        }
        BigDecimal minValue = this.getParameter(parameterList, 1, BigDecimal.class, BigDecimal::new, DEFAULT_MIN_VALUE);
        if (minValue.compareTo(maxValue = this.getParameter(parameterList, 2, BigDecimal.class, BigDecimal::new, DEFAULT_MAX_VALUE)) > 0) {
            throw new InvalidFunctionUsageException("Min value must be less than max value.");
        }
        boolean excludeMin = this.getParameter(parameterList, 3, Boolean.class, Boolean::parseBoolean, false);
        boolean excludeMax = this.getParameter(parameterList, 4, Boolean.class, Boolean::parseBoolean, false);
        BigDecimal multiple = this.getParameter(parameterList, 5, BigDecimal.class, BigDecimal::new, null);
        String formatPattern = this.getParameter(parameterList, 6, String.class, v -> v, null);
        BigDecimal randomValue = this.getRandomNumber(decimalPlaces, minValue, maxValue, excludeMin, excludeMax, multiple);
        return AdvancedRandomNumberFunction.formatRandomNumber(randomValue, decimalPlaces, formatPattern);
    }

    private <T> T getParameter(List<String> params, int index, Class<T> type, java.util.function.Function<String, T> parser, T defaultValue) {
        if (index < params.size()) {
            String param = params.get(index);
            return "null".equals(param) ? defaultValue : this.parseParameter(index + 1, param, type, parser);
        }
        return defaultValue;
    }

    private <T> T parseParameter(int index, String text, Class<T> type, java.util.function.Function<String, T> parseFunction) {
        try {
            T value = parseFunction.apply(text);
            if (value == null) {
                throw new CitrusRuntimeException("Text '%s' could not be parsed to '%s'. Resulting value is null".formatted(text, type.getSimpleName()));
            }
            return value;
        }
        catch (Exception e) {
            throw new InvalidFunctionUsageException(String.format("Invalid parameter at index %d. %s must be parsable to %s.", index, text, type.getSimpleName()));
        }
    }

    private BigDecimal getRandomNumber(int decimalPlaces, BigDecimal minValue, BigDecimal maxValue, boolean excludeMin, boolean excludeMax, BigDecimal multiple) {
        BigDecimal randomValue;
        minValue = excludeMin ? this.incrementToExclude(minValue) : minValue;
        maxValue = excludeMax ? this.decrementToExclude(maxValue) : maxValue;
        BigDecimal range = maxValue.subtract(minValue);
        if (multiple != null) {
            randomValue = this.createMultipleOf(minValue, maxValue, multiple);
        } else {
            randomValue = this.createRandomValue(minValue, range, ThreadLocalRandom.current().nextDouble());
            randomValue = randomValue.setScale(decimalPlaces, RoundingMode.HALF_UP);
        }
        return randomValue;
    }

    public static String formatRandomNumber(BigDecimal randomValue, int decimalPlaces, String formatPattern) {
        if (randomValue == null) {
            return String.format("%s", Double.POSITIVE_INFINITY);
        }
        if (formatPattern != null && !formatPattern.isEmpty()) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
            DecimalFormat decimalFormat = new DecimalFormat(formatPattern, symbols);
            return decimalFormat.format(randomValue);
        }
        return decimalPlaces == 0 ? randomValue.toPlainString() : randomValue.setScale(decimalPlaces, RoundingMode.HALF_UP).toPlainString();
    }

    private static boolean isWithinDoubleRange(BigDecimal value) {
        BigDecimal maxDouble = BigDecimal.valueOf(Double.MAX_VALUE);
        BigDecimal minDouble = maxDouble.negate();
        return value.compareTo(minDouble) >= 0 && value.compareTo(maxDouble) <= 0;
    }

    BigDecimal createRandomValue(BigDecimal minValue, BigDecimal range, double random) {
        BigDecimal offset = range.multiply(BigDecimal.valueOf(random));
        BigDecimal value = minValue.add(offset);
        return value.compareTo(BigDecimal.valueOf(Double.MAX_VALUE)) > 0 ? BigDecimal.valueOf(Double.MAX_VALUE) : value;
    }

    private BigDecimal largestMultipleOf(BigDecimal highest, BigDecimal multipleOf) {
        RoundingMode roundingMode = highest.compareTo(BigDecimal.ZERO) < 0 ? RoundingMode.UP : RoundingMode.DOWN;
        BigDecimal factor = highest.divide(multipleOf, 0, roundingMode);
        return multipleOf.multiply(factor);
    }

    private BigDecimal lowestMultipleOf(BigDecimal lowest, BigDecimal multipleOf) {
        RoundingMode roundingMode = lowest.compareTo(BigDecimal.ZERO) < 0 ? RoundingMode.DOWN : RoundingMode.UP;
        BigDecimal factor = lowest.divide(multipleOf, 0, roundingMode);
        return multipleOf.multiply(factor);
    }

    private BigDecimal incrementToExclude(BigDecimal val) {
        return val.add(this.determineIncrement(val)).setScale(this.findLeastSignificantDecimalPlace(val), RoundingMode.HALF_DOWN);
    }

    private BigDecimal decrementToExclude(BigDecimal val) {
        return val.subtract(this.determineIncrement(val)).setScale(this.findLeastSignificantDecimalPlace(val), RoundingMode.HALF_DOWN);
    }

    private BigDecimal determineIncrement(BigDecimal number) {
        return BigDecimal.valueOf(1.0 / Math.pow(10.0, this.findLeastSignificantDecimalPlace(number)));
    }

    private int findLeastSignificantDecimalPlace(BigDecimal number) {
        String[] parts = (number = number.stripTrailingZeros()).toPlainString().split("\\.");
        if (parts.length == 1) {
            return 0;
        }
        return parts[1].length();
    }

    private BigDecimal createMultipleOf(BigDecimal minimum, BigDecimal maximum, BigDecimal multipleOf) {
        BigDecimal largestMultiple;
        BigDecimal lowestMultiple = this.lowestMultipleOf(minimum, multipleOf);
        if (lowestMultiple.compareTo(largestMultiple = this.largestMultipleOf(maximum, multipleOf)) > 0) {
            return null;
        }
        BigDecimal range = largestMultiple.subtract(lowestMultiple).divide(multipleOf, RoundingMode.DOWN);
        if (range.compareTo(BigDecimal.valueOf(11L)) > 0) {
            range = BigDecimal.valueOf(10L);
        }
        long factor = 0L;
        if (range.compareTo(BigDecimal.ZERO) != 0) {
            factor = ThreadLocalRandom.current().nextLong(1L, range.longValue() + 1L);
        }
        BigDecimal randomMultiple = lowestMultiple.add(multipleOf.multiply(BigDecimal.valueOf(factor)));
        randomMultiple = randomMultiple.setScale(this.findLeastSignificantDecimalPlace(multipleOf), RoundingMode.HALF_UP);
        return randomMultiple;
    }
}

