/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import org.citrusframework.AbstractTestBoundaryContainerBuilder;
import org.citrusframework.AbstractTestContainerBuilder;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.container.AbstractTestBoundaryActionContainer;
import org.citrusframework.container.AfterTest;
import org.citrusframework.container.SequenceAfterSuite;
import org.citrusframework.context.TestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceAfterTest
extends AbstractTestBoundaryActionContainer
implements AfterTest {
    private static final Logger logger = LoggerFactory.getLogger(SequenceAfterTest.class);

    public SequenceAfterTest() {
        this(new SequenceAfterSuite.Builder());
    }

    public SequenceAfterTest(AbstractTestContainerBuilder<?, ?> builder) {
        super("after-test", builder);
    }

    @Override
    public void doExecute(TestContext context) {
        if (this.actions == null || this.actions.isEmpty()) {
            return;
        }
        logger.info("Entering after test block");
        if (logger.isDebugEnabled()) {
            logger.debug("Executing {} actions after test", (Object)this.actions.size());
            logger.debug("");
        }
        for (TestActionBuilder actionBuilder : this.actions) {
            TestAction action = actionBuilder.build();
            action.execute(context);
        }
    }

    public static class Builder
    extends AbstractTestBoundaryContainerBuilder<SequenceAfterTest, Builder> {
        public static Builder afterTest() {
            return new Builder();
        }

        @Override
        public SequenceAfterTest doBuild() {
            return new SequenceAfterTest(this);
        }
    }
}

