/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import java.util.Date;
import org.citrusframework.DefaultTestActions;
import org.citrusframework.DefaultTestCase;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestActionContainers;
import org.citrusframework.TestActionRunner;
import org.citrusframework.TestActions;
import org.citrusframework.TestBehavior;
import org.citrusframework.TestCase;
import org.citrusframework.TestCaseMetaInfo;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.TestCaseRunnerProvider;
import org.citrusframework.TestGroupAware;
import org.citrusframework.actions.ApplyTestBehaviorAction;
import org.citrusframework.container.FinallySequence;
import org.citrusframework.context.TestContext;
import org.citrusframework.message.DefaultMessageProcessors;
import org.citrusframework.message.Processors;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.validation.DefaultValidations;
import org.citrusframework.validation.Validations;
import org.citrusframework.variable.DefaultVariableExtractors;
import org.citrusframework.variable.VariableExtractors;

public class DefaultTestCaseRunner
implements TestCaseRunner {
    private TestCase testCase;
    private final TestContext context;

    public DefaultTestCaseRunner(TestContext context) {
        this(new DefaultTestCase(), context);
    }

    public DefaultTestCaseRunner(TestCase testCase, TestContext context) {
        this.testCase = testCase;
        this.context = context;
        this.testCase.setIncremental(true);
    }

    public TestContext getContext() {
        return this.context;
    }

    public void start() {
        this.testCase.start(this.context);
    }

    public void stop() {
        this.testCase.finish(this.context);
    }

    public <T> T variable(String name, T value) {
        this.testCase.getVariableDefinitions().put(name, value);
        if (value instanceof String) {
            String resolved = this.context.replaceDynamicContentInString(value.toString());
            this.context.setVariable(name, (Object)resolved);
            return (T)resolved;
        }
        this.context.setVariable(name, value);
        return value;
    }

    public void testClass(Class<?> type) {
        this.testCase.setTestClass(type);
    }

    public void name(String name) {
        this.testCase.setName(name);
    }

    public void description(String description) {
        this.testCase.setDescription(description);
    }

    public void author(String author) {
        this.testCase.getMetaInfo().setAuthor(author);
    }

    public void packageName(String packageName) {
        this.testCase.setPackageName(packageName);
    }

    public void status(TestCaseMetaInfo.Status status) {
        this.testCase.getMetaInfo().setStatus(status);
    }

    public void creationDate(Date date) {
        this.testCase.getMetaInfo().setCreationDate(date);
    }

    public void groups(String[] groups) {
        if (this.testCase instanceof TestGroupAware) {
            ((TestGroupAware)this.testCase).setGroups(groups);
        }
    }

    public TestActions actions() {
        return new DefaultTestActions();
    }

    public TestActionContainers containers() {
        return new DefaultTestActions();
    }

    public Validations validation() {
        return new DefaultValidations();
    }

    public VariableExtractors extractor() {
        return new DefaultVariableExtractors();
    }

    public Processors processor() {
        return new DefaultMessageProcessors();
    }

    public <T extends TestAction> TestActionRunner run(TestActionBuilder<T> builder) {
        if (builder instanceof ReferenceResolverAware) {
            ((ReferenceResolverAware)builder).setReferenceResolver(this.context.getReferenceResolver());
        }
        if (builder instanceof ApplyTestBehaviorAction.Builder) {
            ((ApplyTestBehaviorAction.Builder)builder).on((TestActionRunner)this);
        }
        TestAction action = builder.build();
        if (builder instanceof FinallySequence.Builder) {
            ((FinallySequence.Builder)builder).getActions().forEach(arg_0 -> ((TestCase)this.testCase).addFinalAction(arg_0));
            return this;
        }
        this.testCase.addTestAction(action);
        this.testCase.executeAction(action, this.context);
        return this;
    }

    public ApplyTestBehaviorAction.Builder applyBehavior(TestBehavior behavior) {
        return new ApplyTestBehaviorAction.Builder().behavior(behavior).on((TestActionRunner)this);
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public void setTestCase(TestCase testCase) {
        this.testCase = testCase;
        this.testCase.setIncremental(true);
    }

    public static class DefaultTestCaseRunnerProvider
    implements TestCaseRunnerProvider {
        public TestCaseRunner createTestCaseRunner(TestContext context) {
            return new DefaultTestCaseRunner(context);
        }

        public TestCaseRunner createTestCaseRunner(TestCase testCase, TestContext context) {
            return new DefaultTestCaseRunner(testCase, context);
        }
    }
}

