/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.xml;

import java.util.HashMap;
import java.util.Map;
import org.citrusframework.message.DelegatingPathExpressionProcessor;
import org.citrusframework.message.MessageProcessor;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.DelegatingPayloadVariableExtractor;
import org.citrusframework.validation.xml.XmlMessageValidationContext;
import org.citrusframework.validation.xml.XpathMessageValidationContextBuilder;
import org.citrusframework.variable.VariableExtractor;

public class XpathMessageValidationContext
extends XmlMessageValidationContext {
    private final Map<String, Object> xPathExpressions;

    public XpathMessageValidationContext() {
        this(new Builder());
    }

    public XpathMessageValidationContext(Builder builder) {
        super(builder);
        this.xPathExpressions = builder.expressions;
    }

    public boolean requiresValidator() {
        return true;
    }

    public Map<String, Object> getXpathExpressions() {
        return this.xPathExpressions;
    }

    public static boolean isXpathExpression(String pathExpression) {
        return StringUtils.hasText(pathExpression) && pathExpression.startsWith("/");
    }

    public static final class Builder
    extends XmlMessageValidationContext.XmlValidationContextBuilder<XpathMessageValidationContext, Builder>
    implements XpathMessageValidationContextBuilder<XpathMessageValidationContext, Builder> {
        private final Map<String, Object> expressions = new HashMap<String, Object>();

        public static Builder xpath() {
            return new Builder();
        }

        public Builder expressions(Map<String, Object> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder expression(String expression, Object value) {
            this.expressions.put(expression, value);
            return this;
        }

        public MessageProcessor asProcessor() {
            return ((DelegatingPathExpressionProcessor.Builder)new DelegatingPathExpressionProcessor.Builder().expressions((Map)this.expressions)).build();
        }

        public VariableExtractor asExtractor() {
            return ((DelegatingPayloadVariableExtractor.Builder)new DelegatingPayloadVariableExtractor.Builder().expressions((Map)this.expressions)).build();
        }

        public XpathMessageValidationContext build() {
            return new XpathMessageValidationContext(this);
        }
    }
}

