/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.interceptor;

import java.nio.charset.Charset;
import org.citrusframework.CitrusSettings;
import org.citrusframework.context.TestContext;
import org.citrusframework.message.AbstractMessageProcessor;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageType;
import org.citrusframework.message.processor.BinaryMessageProcessorBuilder;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;

public class BinaryMessageProcessor
extends AbstractMessageProcessor {
    private final Charset encoding;

    public BinaryMessageProcessor() {
        this(Builder.toBinary());
    }

    public BinaryMessageProcessor(Builder builder) {
        this.encoding = builder.encoding;
    }

    protected void processMessage(Message message, TestContext context) {
        if (message.getPayload() instanceof String) {
            message.setPayload((Object)((String)message.getPayload(String.class)).getBytes(this.encoding));
        } else if (message.getPayload() instanceof Resource) {
            message.setPayload((Object)FileUtils.copyToByteArray((Resource)message.getPayload(Resource.class)));
        } else {
            message.setPayload(message.getPayload(byte[].class));
        }
        message.setType(MessageType.BINARY.name());
    }

    public static final class Builder
    implements BinaryMessageProcessorBuilder<BinaryMessageProcessor, Builder> {
        private Charset encoding = Charset.forName(CitrusSettings.CITRUS_FILE_ENCODING);

        public static Builder toBinary() {
            return new Builder();
        }

        public Builder encoding(String charsetName) {
            return this.encoding(Charset.forName(charsetName));
        }

        public Builder encoding(Charset encoding) {
            this.encoding = encoding;
            return this;
        }

        public BinaryMessageProcessor build() {
            return new BinaryMessageProcessor(this);
        }
    }
}

