/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.server;

import org.citrusframework.endpoint.AbstractEndpointBuilder;
import org.citrusframework.endpoint.EndpointAdapter;
import org.citrusframework.server.AbstractServer;
import org.citrusframework.util.StringUtils;
import org.citrusframework.yaml.SchemaProperty;

public abstract class AbstractServerBuilder<T extends AbstractServer, B extends AbstractServerBuilder<T, B>>
extends AbstractEndpointBuilder<T> {
    private final B self = this;
    private String endpointAdapter;

    protected AbstractServerBuilder() {
    }

    @Override
    public T build() {
        if (this.referenceResolver != null && StringUtils.hasText(this.endpointAdapter)) {
            this.endpointAdapter((EndpointAdapter)this.referenceResolver.resolve(this.endpointAdapter, EndpointAdapter.class));
        }
        return (T)((AbstractServer)super.build());
    }

    public B autoStart(boolean autoStart) {
        ((AbstractServer)this.getEndpoint()).setAutoStart(autoStart);
        return this.self;
    }

    @SchemaProperty(description="When enabled the server is automatically started after creation.")
    public void setAutoStart(boolean autoStart) {
        this.autoStart(autoStart);
    }

    public B endpointAdapter(EndpointAdapter endpointAdapter) {
        ((AbstractServer)this.getEndpoint()).setEndpointAdapter(endpointAdapter);
        return this.self;
    }

    @SchemaProperty(advanced=true, description="Sets a custom endpoint adapter to handle requests.")
    public void setEndpointAdapter(String endpointAdapter) {
        this.endpointAdapter = endpointAdapter;
    }

    public B debugLogging(boolean enabled) {
        ((AbstractServer)this.getEndpoint()).setDebugLogging(enabled);
        return this.self;
    }

    @SchemaProperty(advanced=true, description="When enabled the server prints debug logging output.")
    public void setDebugLogging(boolean enabled) {
        this.debugLogging(enabled);
    }

    public B timeout(long timeout) {
        if (((AbstractServer)this.getEndpoint()).getEndpointConfiguration() != null) {
            ((AbstractServer)this.getEndpoint()).getEndpointConfiguration().setTimeout(timeout);
        }
        ((AbstractServer)this.getEndpoint()).setDefaultTimeout(timeout);
        return this.self;
    }

    @SchemaProperty(description="The server timeout.", defaultValue="5000")
    public void setTimeout(long timeout) {
        this.timeout(timeout);
    }
}

