/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.server;

import java.util.ArrayList;
import java.util.List;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.common.ShutdownPhase;
import org.citrusframework.context.TestContextFactory;
import org.citrusframework.endpoint.AbstractEndpoint;
import org.citrusframework.endpoint.EndpointAdapter;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.endpoint.direct.DirectEndpointAdapter;
import org.citrusframework.endpoint.direct.DirectSyncEndpointConfiguration;
import org.citrusframework.message.DefaultMessageQueue;
import org.citrusframework.message.MessageQueue;
import org.citrusframework.messaging.Consumer;
import org.citrusframework.messaging.Producer;
import org.citrusframework.server.Server;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer
extends AbstractEndpoint
implements Server,
InitializingPhase,
ShutdownPhase,
ReferenceResolverAware {
    public static final String DEFAULT_CHANNEL_ID_SUFFIX = ".inbound";
    private boolean running = false;
    private boolean autoStart = false;
    private Thread thread;
    private final Object runningLock = new Object();
    private ReferenceResolver referenceResolver;
    private EndpointAdapter endpointAdapter;
    private List<Object> interceptors = new ArrayList<Object>();
    private long defaultTimeout = 1000L;
    private boolean debugLogging = false;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public AbstractServer() {
        super(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.logger.debug("Starting server: {} ...", (Object)this.getName());
        this.startup();
        Object object = this.runningLock;
        synchronized (object) {
            this.running = true;
        }
        this.thread = new Thread((Runnable)((Object)this));
        this.thread.setDaemon(false);
        this.thread.start();
        this.logger.info("Started server: {}", (Object)this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.isRunning()) {
            this.logger.debug("Stopping server: {} ...", (Object)this.getName());
            this.shutdown();
            Object object = this.runningLock;
            synchronized (object) {
                this.running = false;
            }
            this.thread = null;
            this.logger.info("Stopped server: {}", (Object)this.getName());
        }
    }

    public void run() {
    }

    protected abstract void startup();

    protected abstract void shutdown();

    public void initialize() {
        if (this.endpointAdapter == null) {
            DefaultMessageQueue inboundQueue = this.referenceResolver != null && this.referenceResolver.isResolvable(this.getName() + DEFAULT_CHANNEL_ID_SUFFIX) ? (MessageQueue)this.referenceResolver.resolve(this.getName() + DEFAULT_CHANNEL_ID_SUFFIX, MessageQueue.class) : new DefaultMessageQueue(this.getName() + DEFAULT_CHANNEL_ID_SUFFIX);
            if (inboundQueue instanceof DefaultMessageQueue) {
                inboundQueue.setLoggingEnabled(this.debugLogging);
            }
            DirectSyncEndpointConfiguration directEndpointConfiguration = new DirectSyncEndpointConfiguration();
            directEndpointConfiguration.setQueue(inboundQueue);
            directEndpointConfiguration.setTimeout(this.defaultTimeout);
            this.endpointAdapter = new DirectEndpointAdapter(directEndpointConfiguration);
            this.endpointAdapter.getEndpoint().setName(this.getName());
            ((DirectEndpointAdapter)this.endpointAdapter).setTestContextFactory(this.getTestContextFactory());
        }
        if (this.autoStart && !this.isRunning()) {
            this.start();
        }
    }

    private TestContextFactory getTestContextFactory() {
        if (this.referenceResolver != null && !this.referenceResolver.resolveAll(TestContextFactory.class).isEmpty()) {
            return (TestContextFactory)this.referenceResolver.resolve(TestContextFactory.class);
        }
        this.logger.debug("Unable to create test context factory from Spring application context - using minimal test context factory");
        return TestContextFactory.newInstance();
    }

    public void destroy() {
        if (this.isRunning()) {
            this.shutdown();
        }
    }

    public void join() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            this.logger.error("Error occured", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.runningLock;
        synchronized (object) {
            return this.running;
        }
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        return this.endpointAdapter.getEndpoint().getEndpointConfiguration();
    }

    public Consumer createConsumer() {
        return this.endpointAdapter.getEndpoint().createConsumer();
    }

    public Producer createProducer() {
        return this.endpointAdapter.getEndpoint().createProducer();
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public ReferenceResolver getReferenceResolver() {
        return this.referenceResolver;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public EndpointAdapter getEndpointAdapter() {
        return this.endpointAdapter;
    }

    public void setEndpointAdapter(EndpointAdapter endpointAdapter) {
        this.endpointAdapter = endpointAdapter;
    }

    public List<Object> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<Object> interceptors) {
        this.interceptors = interceptors;
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public void setDebugLogging(boolean debugLogging) {
        this.debugLogging = debugLogging;
    }

    public boolean isDebugLogging() {
        return this.debugLogging;
    }
}

