/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageQueue;
import org.citrusframework.message.MessageSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageQueue
implements MessageQueue {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMessageQueue.class);
    private static final Logger RETRY_LOG = LoggerFactory.getLogger((String)"org.citrusframework.RetryLogger");
    private final BlockingQueue<Message> queue = new LinkedBlockingQueue<Message>();
    private long pollingInterval = 500L;
    private boolean loggingEnabled = false;
    private final String name;

    public DefaultMessageQueue(String name) {
        this.name = name;
    }

    public void send(Message message) {
        this.queue.add(message);
    }

    public Message receive(MessageSelector selector) {
        Object[] array;
        for (Object o : array = this.queue.toArray()) {
            Message message = (Message)o;
            if (!selector.accept(message) || !this.queue.remove(message)) continue;
            return message;
        }
        return null;
    }

    public Message receive(MessageSelector selector, long timeout) {
        long timeLeft = timeout;
        Message message = this.receive(selector);
        while (message == null && timeLeft > 0L) {
            timeLeft -= this.pollingInterval;
            if (RETRY_LOG.isDebugEnabled()) {
                RETRY_LOG.debug("No message received with message selector - retrying in {}ms", (Object)(timeLeft > 0L ? this.pollingInterval : this.pollingInterval + timeLeft));
            }
            try {
                Thread.sleep(timeLeft > 0L ? this.pollingInterval : this.pollingInterval + timeLeft);
            }
            catch (InterruptedException e) {
                RETRY_LOG.warn("Thread interrupted while waiting for retry", (Throwable)e);
            }
            message = this.receive(selector);
        }
        return message;
    }

    public void purge(MessageSelector selector) {
        Object[] array;
        for (Object o : array = this.queue.toArray()) {
            Message message = (Message)o;
            if (!selector.accept(message)) continue;
            if (this.queue.remove(message)) {
                logger.debug("Purged message '{}' from in memory queue", (Object)message.getId());
                continue;
            }
            logger.warn("Failed to purge message '{}' from in memory queue", (Object)message.getId());
        }
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(long pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

