/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.parameter;

import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.ParameterizedFunction;
import org.citrusframework.yaml.SchemaProperty;

public class NumberParameter
implements ParameterizedFunction.FunctionParameters {
    private String value;

    public void configure(List<String> parameterList, TestContext context) {
        if (parameterList == null || parameterList.isEmpty()) {
            throw new InvalidFunctionUsageException("Function parameters must not be empty");
        }
        this.setValue(context.replaceDynamicContentInString(parameterList.get(0)));
    }

    public int asInteger() {
        return Integer.getInteger(this.getValue());
    }

    public double asDouble() {
        return Double.parseDouble(this.getValue());
    }

    public String getValue() {
        return this.value;
    }

    @SchemaProperty(required=true, description="The numeric value to evaluate.")
    public void setValue(double value) {
        this.value = String.valueOf(value);
    }

    public void setValue(String value) {
        this.value = value;
    }
}

