/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.ParameterizedFunction;
import org.citrusframework.yaml.SchemaProperty;

public class DigestAuthHeaderFunction
implements ParameterizedFunction<Parameters> {
    private Long nonceValidity = 60000L;

    public String execute(Parameters params, TestContext context) {
        StringBuilder authorizationHeader = new StringBuilder();
        String digest1 = params.getUsername() + ":" + params.getRealm() + ":" + params.getPassword();
        String digest2 = params.getMethod() + ":" + params.getUri();
        Long expirationTime = System.currentTimeMillis() + this.nonceValidity;
        String nonce = Base64.encodeBase64String((byte[])(expirationTime + ":" + this.getDigestHex(params.getAlgorithm(), expirationTime + ":" + params.getNoncekey())).getBytes());
        authorizationHeader.append("Digest username=");
        authorizationHeader.append(params.getUsername());
        authorizationHeader.append(",realm=");
        authorizationHeader.append(params.getRealm());
        authorizationHeader.append(",nonce=");
        authorizationHeader.append(nonce);
        authorizationHeader.append(",uri=");
        authorizationHeader.append(params.getUri());
        authorizationHeader.append(",response=");
        authorizationHeader.append(this.getDigestHex(params.getAlgorithm(), this.getDigestHex(params.getAlgorithm(), digest1) + ":" + nonce + ":" + this.getDigestHex(params.getAlgorithm(), digest2)));
        authorizationHeader.append(",opaque=");
        authorizationHeader.append(this.getDigestHex(params.getAlgorithm(), params.getOpaque()));
        authorizationHeader.append(",algorithm=");
        authorizationHeader.append(params.getAlgorithm());
        return authorizationHeader.toString();
    }

    private String getDigestHex(String algorithm, String key) {
        if (algorithm.equals("md5")) {
            return DigestUtils.md5Hex((String)key);
        }
        if (algorithm.equals("sha")) {
            return DigestUtils.shaHex((String)key);
        }
        throw new CitrusRuntimeException("Unsupported digest algorithm: " + algorithm);
    }

    public void setNonceValidity(Long nonceValidity) {
        this.nonceValidity = nonceValidity;
    }

    public Parameters getParameters() {
        return new Parameters();
    }

    public static class Parameters
    implements ParameterizedFunction.FunctionParameters {
        private String username;
        private String password;
        private String realm;
        private String noncekey;
        private String method;
        private String uri;
        private String opaque;
        private String algorithm;

        public void configure(List<String> parameterList, TestContext context) {
            if (parameterList == null || parameterList.size() < 8) {
                throw new InvalidFunctionUsageException("Function parameters not set correctly - need parameters: username,password,realm,noncekey,method,uri,opaque,algorithm");
            }
            this.setUsername(parameterList.get(0));
            this.setPassword(parameterList.get(1));
            this.setRealm(parameterList.get(2));
            this.setNoncekey(parameterList.get(3));
            this.setMethod(parameterList.get(4));
            this.setUri(parameterList.get(5));
            this.setOpaque(parameterList.get(6));
            this.setAlgorithm(parameterList.get(7));
        }

        public String getUsername() {
            return this.username;
        }

        @SchemaProperty(required=true, description="The username.")
        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        @SchemaProperty(required=true, description="The password.")
        public void setPassword(String password) {
            this.password = password;
        }

        public String getRealm() {
            return this.realm;
        }

        @SchemaProperty(required=true, description="The realm.")
        public void setRealm(String realm) {
            this.realm = realm;
        }

        public String getNoncekey() {
            return this.noncekey;
        }

        @SchemaProperty(required=true, description="The noncekey.")
        public void setNoncekey(String noncekey) {
            this.noncekey = noncekey;
        }

        public String getMethod() {
            return this.method;
        }

        @SchemaProperty(required=true, description="The method.")
        public void setMethod(String method) {
            this.method = method;
        }

        public String getUri() {
            return this.uri;
        }

        @SchemaProperty(required=true, description="The uri.")
        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getOpaque() {
            return this.opaque;
        }

        @SchemaProperty(required=true, description="The opaque.")
        public void setOpaque(String opaque) {
            this.opaque = opaque;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        @SchemaProperty(required=true, description="The algorithm.")
        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }
    }
}

