/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint.direct;

import jakarta.annotation.Nullable;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointBuilder;
import org.citrusframework.endpoint.direct.DirectEndpointBuilder;
import org.citrusframework.endpoint.direct.DirectSyncEndpointBuilder;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.yaml.SchemaProperty;
import org.citrusframework.yaml.SchemaType;

@SchemaType(oneOf={"asynchronous", "synchronous"})
public class DirectEndpointsBuilder
implements EndpointBuilder<Endpoint>,
ReferenceResolverAware {
    private EndpointBuilder<?> delegate;
    private ReferenceResolver referenceResolver;

    @SchemaProperty(description="Sets the synchronous direct endpoint.")
    public void setSynchronous(DirectSyncEndpointBuilder builder) {
        this.delegate = builder;
    }

    @SchemaProperty(description="Sets the direct endpoint.")
    public void setAsynchronous(DirectEndpointBuilder builder) {
        this.delegate = builder;
    }

    public Endpoint build() {
        EndpointBuilder<?> endpointBuilder;
        if (this.delegate == null) {
            throw new CitrusRuntimeException("Sync/async endpoint builder has not been initialized");
        }
        if (this.referenceResolver != null && (endpointBuilder = this.delegate) instanceof ReferenceResolverAware) {
            ReferenceResolverAware resolverAware = (ReferenceResolverAware)endpointBuilder;
            resolverAware.setReferenceResolver(this.referenceResolver);
        }
        return this.delegate.build();
    }

    public boolean supports(Class<?> endpointType) {
        return this.delegate.supports(endpointType);
    }

    public void setReferenceResolver(@Nullable ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }
}

