/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.actions.CreateEndpointActionBuilder;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointBuilder;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateEndpointAction
extends AbstractTestAction {
    private final EndpointBuilder<?> endpointBuilder;
    private final String endpointName;
    private final String endpointUri;
    private static final Logger logger = LoggerFactory.getLogger(CreateEndpointAction.class);

    private CreateEndpointAction(Builder builder) {
        super("create-endpoint", builder);
        this.endpointBuilder = builder.endpointBuilder;
        this.endpointUri = builder.endpointUri;
        this.endpointName = builder.endpointName;
    }

    @Override
    public void doExecute(TestContext context) {
        String resolvedEndpointName;
        Endpoint endpoint;
        if (this.endpointBuilder != null) {
            EndpointBuilder<?> endpointBuilder = this.endpointBuilder;
            if (endpointBuilder instanceof ReferenceResolverAware) {
                ReferenceResolverAware resolverAware = (ReferenceResolverAware)endpointBuilder;
                resolverAware.setReferenceResolver(context.getReferenceResolver());
            }
            endpoint = this.endpointBuilder.build();
            if (StringUtils.hasText(this.endpointName)) {
                endpoint.setName(this.endpointName);
            }
            resolvedEndpointName = endpoint.getName();
            logger.info("Creating endpoint {}", (Object)resolvedEndpointName);
        } else {
            resolvedEndpointName = Optional.ofNullable(this.endpointName).orElse("");
            logger.info("Creating endpoint {} '{}'", (Object)resolvedEndpointName, (Object)this.endpointUri);
            endpoint = context.getEndpointFactory().create(context.replaceDynamicContentInString(this.endpointUri), context);
        }
        if (StringUtils.hasText(resolvedEndpointName)) {
            if (context.getReferenceResolver().isResolvable(resolvedEndpointName)) {
                logger.warn("Skip binding endpoint to bean registry, because endpoint already exists: {}", (Object)resolvedEndpointName);
            } else {
                logger.info("Binding endpoint {} to bean registry", (Object)resolvedEndpointName);
                context.getReferenceResolver().bind(resolvedEndpointName, (Object)endpoint);
                if (endpoint instanceof InitializingPhase) {
                    InitializingPhase initializingPhase = (InitializingPhase)endpoint;
                    initializingPhase.initialize();
                }
            }
        }
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public EndpointBuilder<?> getEndpointBuilder() {
        return this.endpointBuilder;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<CreateEndpointAction, Builder>
    implements CreateEndpointActionBuilder<CreateEndpointAction> {
        private EndpointBuilder<?> endpointBuilder;
        private String endpointName;
        private String endpointUri;
        private String type;
        private final Map<String, String> properties = new LinkedHashMap<String, String>();

        public static Builder createEndpoint(String type, Map<String, String> properties) {
            Builder builder = new Builder();
            builder.type(type);
            builder.properties((Map)properties);
            return builder;
        }

        public static Builder createEndpoint(String endpointUri) {
            return new Builder().uri(endpointUri);
        }

        public static Builder createEndpoint() {
            return new Builder();
        }

        public Builder endpoint(EndpointBuilder<?> builder) {
            this.endpointBuilder = builder;
            return this;
        }

        public Builder uri(String endpointUri) {
            this.endpointUri = endpointUri;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder endpointName(String name) {
            this.endpointName = name;
            return this.property("endpointName", name);
        }

        public Builder property(String name, String value) {
            this.properties.put(name, value);
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public CreateEndpointAction build() {
            if (this.endpointBuilder == null) {
                if (this.endpointUri == null && this.type == null) {
                    throw new CitrusRuntimeException("Failed to build endpoint specification - please specify an endpoint URI or a type");
                }
                if (this.endpointUri == null) {
                    this.endpointUri = this.properties.isEmpty() ? this.type : "%s?%s".formatted(this.type, this.properties.entrySet().stream().map(entry -> "%s=%s".formatted(entry.getKey(), entry.getValue())).collect(Collectors.joining("&")));
                }
            }
            return new CreateEndpointAction(this);
        }
    }
}

