/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message.builder;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.CitrusSettings;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.actions.MessageBuilderFactory;
import org.citrusframework.common.Named;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.message.MessageHeaderBuilder;
import org.citrusframework.message.MessageHeaderDataBuilder;
import org.citrusframework.message.MessagePayloadBuilder;
import org.citrusframework.message.MessageProcessor;
import org.citrusframework.message.MessageProcessorAdapter;
import org.citrusframework.message.MessageType;
import org.citrusframework.message.WithHeaderBuilder;
import org.citrusframework.message.WithPayloadBuilder;
import org.citrusframework.message.builder.DefaultHeaderBuilder;
import org.citrusframework.message.builder.DefaultHeaderDataBuilder;
import org.citrusframework.message.builder.DefaultPayloadBuilder;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.validation.builder.DefaultMessageBuilder;
import org.citrusframework.validation.builder.StaticMessageBuilder;
import org.citrusframework.variable.VariableExtractor;
import org.citrusframework.variable.VariableExtractorAdapter;
import org.citrusframework.variable.dictionary.DataDictionary;

public abstract class MessageBuilderSupport<T extends TestAction, B extends MessageActionBuilder<T, S, B>, S extends MessageBuilderSupport<T, B, S>>
implements TestActionBuilder<T>,
ReferenceResolverAware,
MessageBuilderFactory<T, S> {
    protected final S self;
    protected MessageBuilder messageBuilder = new DefaultMessageBuilder();
    protected final B delegate;
    protected String messageType = CitrusSettings.DEFAULT_MESSAGE_TYPE;
    private boolean isExplicitMessageType = false;
    protected DataDictionary<?> dataDictionary;
    protected String dataDictionaryName;

    protected MessageBuilderSupport(B delegate) {
        this.self = this;
        this.delegate = delegate;
    }

    public S from(MessageBuilder messageBuilder) {
        this.messageBuilder = messageBuilder;
        return this.self;
    }

    public S from(Message controlMessage) {
        this.messageBuilder = StaticMessageBuilder.withMessage(controlMessage);
        this.type(controlMessage.getType());
        return this.self;
    }

    public S type(MessageType messageType) {
        this.type(messageType.name());
        return this.self;
    }

    public S type(String messageType) {
        this.messageType = messageType;
        this.isExplicitMessageType = true;
        return this.self;
    }

    public S body(MessagePayloadBuilder.Builder<?, ?> payloadBuilder) {
        this.body(payloadBuilder.build());
        return this.self;
    }

    public S body(MessagePayloadBuilder payloadBuilder) {
        MessageBuilder messageBuilder = this.messageBuilder;
        if (!(messageBuilder instanceof WithPayloadBuilder)) {
            throw new CitrusRuntimeException("Unable to set payload builder on message builder type: " + this.messageBuilder.getClass());
        }
        WithPayloadBuilder withPayloadBuilder = (WithPayloadBuilder)messageBuilder;
        withPayloadBuilder.setPayloadBuilder(payloadBuilder);
        return this.self;
    }

    public S body(String payload) {
        this.body(new DefaultPayloadBuilder(payload));
        return this.self;
    }

    public S body(Resource payloadResource) {
        return (S)this.body(payloadResource, FileUtils.getDefaultCharset());
    }

    public S body(Resource payloadResource, Charset charset) {
        try {
            this.body(FileUtils.readToString(payloadResource, charset));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read payload resource", (Throwable)e);
        }
        return this.self;
    }

    public S header(String name, Object value) {
        MessageBuilder messageBuilder = this.messageBuilder;
        if (!(messageBuilder instanceof WithHeaderBuilder)) {
            throw new CitrusRuntimeException("Unable to set message header on builder type: " + this.messageBuilder.getClass());
        }
        WithHeaderBuilder withHeaderBuilder = (WithHeaderBuilder)messageBuilder;
        withHeaderBuilder.addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderBuilder(Collections.singletonMap(name, value)));
        return this.self;
    }

    public S headers(Map<String, Object> headers) {
        MessageBuilder messageBuilder = this.messageBuilder;
        if (!(messageBuilder instanceof WithHeaderBuilder)) {
            throw new CitrusRuntimeException("Unable to set message header on builder type: " + this.messageBuilder.getClass());
        }
        WithHeaderBuilder withHeaderBuilder = (WithHeaderBuilder)messageBuilder;
        withHeaderBuilder.addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderBuilder(headers));
        return this.self;
    }

    public S header(String data) {
        this.header(new DefaultHeaderDataBuilder(data));
        return this.self;
    }

    public S header(MessageHeaderDataBuilder headerDataBuilder) {
        MessageBuilder messageBuilder = this.messageBuilder;
        if (!(messageBuilder instanceof WithHeaderBuilder)) {
            throw new CitrusRuntimeException("Unable to set message header data on builder type: " + this.messageBuilder.getClass());
        }
        WithHeaderBuilder withHeaderBuilder = (WithHeaderBuilder)messageBuilder;
        withHeaderBuilder.addHeaderBuilder((MessageHeaderBuilder)headerDataBuilder);
        return this.self;
    }

    public S header(Resource resource) {
        return (S)this.header(resource, FileUtils.getDefaultCharset());
    }

    public S header(Resource resource, Charset charset) {
        try {
            MessageBuilder messageBuilder = this.messageBuilder;
            if (!(messageBuilder instanceof WithHeaderBuilder)) {
                throw new CitrusRuntimeException("Unable to set message header data on builder type: " + this.messageBuilder.getClass());
            }
            WithHeaderBuilder withHeaderBuilder = (WithHeaderBuilder)messageBuilder;
            withHeaderBuilder.addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderDataBuilder(FileUtils.readToString(resource, charset)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read header resource", (Throwable)e);
        }
        return this.self;
    }

    public S name(String name) {
        MessageBuilder messageBuilder = this.messageBuilder;
        if (!(messageBuilder instanceof Named)) {
            throw new CitrusRuntimeException("Unable to set message name on builder type: " + this.messageBuilder.getClass());
        }
        Named named = (Named)messageBuilder;
        named.setName(name);
        return this.self;
    }

    public S process(MessageProcessor processor) {
        ((MessageActionBuilder)this.delegate).process(processor);
        return this.self;
    }

    public S process(MessageProcessor.Builder<?, ?> builder) {
        return (S)this.process(builder.build());
    }

    public S process(MessageProcessorAdapter adapter) {
        return (S)this.process(adapter.asProcessor());
    }

    public S extract(VariableExtractor extractor) {
        return (S)this.process((MessageProcessor)extractor);
    }

    public S extract(VariableExtractorAdapter adapter) {
        return (S)this.extract(adapter.asExtractor());
    }

    public S extract(VariableExtractor.Builder<?, ?> builder) {
        return (S)this.extract(builder.build());
    }

    public S dictionary(DataDictionary<?> dictionary) {
        this.dataDictionary = dictionary;
        return this.self;
    }

    public S dictionary(String dictionaryName) {
        this.dataDictionaryName = dictionaryName;
        return this.self;
    }

    public S withReferenceResolver(ReferenceResolver referenceResolver) {
        ((MessageActionBuilder)this.delegate).withReferenceResolver(referenceResolver);
        return this.self;
    }

    public T build() {
        return (T)this.delegate.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        ((MessageActionBuilder)this.delegate).setReferenceResolver(referenceResolver);
    }

    public String getDataDictionaryName() {
        return this.dataDictionaryName;
    }

    public DataDictionary<?> getDataDictionary() {
        return this.dataDictionary;
    }

    public MessageBuilder getMessageBuilder() {
        return this.messageBuilder;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public boolean isExplicitMessageType() {
        return this.isExplicitMessageType;
    }

    public static abstract class MessageActionBuilder<T extends TestAction, M extends MessageBuilderSupport<T, B, M>, B extends MessageActionBuilder<T, M, B>>
    extends AbstractTestActionBuilder<T, B>
    implements ReferenceResolverAware,
    org.citrusframework.actions.MessageActionBuilder {
        protected Endpoint endpoint;
        protected String endpointUri;
        protected final List<VariableExtractor> variableExtractors = new ArrayList<VariableExtractor>();
        protected final List<MessageProcessor> messageProcessors = new ArrayList<MessageProcessor>();
        protected M messageBuilderSupport;
        protected ReferenceResolver referenceResolver;

        public B endpoint(Endpoint messageEndpoint) {
            this.endpoint = messageEndpoint;
            return (B)((MessageActionBuilder)this.self);
        }

        public B endpoint(String messageEndpointUri) {
            this.endpointUri = messageEndpointUri;
            return (B)((MessageActionBuilder)this.self);
        }

        public M message() {
            return this.getMessageBuilderSupport();
        }

        public M message(MessageBuilder messageBuilder) {
            return (M)((MessageBuilderSupport)this.getMessageBuilderSupport()).from(messageBuilder);
        }

        public M message(Message message) {
            return (M)((MessageBuilderSupport)this.getMessageBuilderSupport()).from(message);
        }

        public M extract(VariableExtractor.Builder<?, ?> builder) {
            return (M)((MessageBuilderSupport)this.message()).extract((VariableExtractor.Builder)builder);
        }

        public B transform(MessageProcessor processor) {
            return this.process(processor);
        }

        public B transform(MessageProcessorAdapter adapter) {
            return this.process(adapter);
        }

        public B transform(MessageProcessor.Builder<?, ?> builder) {
            return this.transform(builder.build());
        }

        public B process(MessageProcessor processor) {
            if (processor instanceof VariableExtractor) {
                VariableExtractor variableExtractor = (VariableExtractor)processor;
                this.variableExtractors.add(variableExtractor);
            } else {
                this.messageProcessors.add(processor);
            }
            return (B)((MessageActionBuilder)this.self);
        }

        public B process(MessageProcessor.Builder<?, ?> builder) {
            return this.process(builder.build());
        }

        public B process(MessageProcessorAdapter adapter) {
            return this.process(adapter.asProcessor());
        }

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }

        public B withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return (B)((MessageActionBuilder)this.self);
        }

        public M getMessageBuilderSupport() {
            return this.messageBuilderSupport;
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public String getEndpointUri() {
            return this.endpointUri;
        }

        public List<VariableExtractor> getVariableExtractors() {
            return this.variableExtractors;
        }

        public List<MessageProcessor> getMessageProcessors() {
            return this.messageProcessors;
        }

        protected abstract T doBuild();
    }
}

