/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message.builder;

import java.io.IOException;
import java.nio.charset.Charset;
import org.citrusframework.CitrusSettings;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.MessagePayloadBuilder;
import org.citrusframework.message.MessageType;
import org.citrusframework.message.MessageTypeAware;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;

public class FileResourcePayloadBuilder
implements MessagePayloadBuilder,
MessageTypeAware {
    private String messageType;
    private final String charsetName;
    private final String resourcePath;
    private final Resource resource;

    public FileResourcePayloadBuilder(Resource resource) {
        this(resource, CitrusSettings.CITRUS_FILE_ENCODING);
    }

    public FileResourcePayloadBuilder(Resource resource, String charset) {
        this.charsetName = charset;
        this.resourcePath = null;
        this.resource = resource;
    }

    public FileResourcePayloadBuilder(String resourcePath) {
        this(resourcePath, CitrusSettings.CITRUS_FILE_ENCODING);
    }

    public FileResourcePayloadBuilder(String resourcePath, String charset) {
        this.charsetName = charset;
        this.resourcePath = resourcePath;
        this.resource = null;
    }

    public Object buildPayload(TestContext context) {
        if (this.resource != null) {
            return this.buildFromResource(context);
        }
        return this.buildFromResourcePath(context);
    }

    private Object buildFromResource(TestContext context) {
        if (MessageType.isBinary((String)this.messageType)) {
            return this.resource;
        }
        return context.replaceDynamicContentInString(this.getFileResourceContent(this.resource, context));
    }

    private Object buildFromResourcePath(TestContext context) {
        if (this.resourcePath == null) {
            return "";
        }
        if (MessageType.isBinary((String)this.messageType)) {
            return FileUtils.getFileResource(this.resourcePath, context);
        }
        return context.replaceDynamicContentInString(this.getFileResourceContent(this.resourcePath, context));
    }

    private String getFileResourceContent(String path, TestContext context) {
        Resource fileResource = FileUtils.getFileResource(path, context);
        return this.getFileResourceContent(fileResource, context);
    }

    private String getFileResourceContent(Resource fileResource, TestContext context) {
        try {
            Charset charset = Charset.forName(context.resolveDynamicValue(this.charsetName));
            return FileUtils.readToString(fileResource, charset);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to build message payload from file resource", (Throwable)e);
        }
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getResourcePath() {
        if (this.resource != null) {
            return this.resource.getLocation();
        }
        return this.resourcePath;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }
}

