/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message;

import org.citrusframework.message.DelegatingPathExpressionProcessor;
import org.citrusframework.message.MessageProcessorLookupSupport;
import org.citrusframework.message.Processors;
import org.citrusframework.message.processor.DelegatingVariableExtractorBuilder;
import org.citrusframework.message.processor.camel.CamelMessageProcessors;
import org.citrusframework.message.processor.json.JsonMappingValidationProcessorBuilder;
import org.citrusframework.message.processor.json.JsonMessageProcessors;
import org.citrusframework.message.processor.json.JsonPathMessageProcessorBuilder;
import org.citrusframework.message.processor.xml.XmlMarshallingValidationProcessorBuilder;
import org.citrusframework.message.processor.xml.XmlMessageProcessors;
import org.citrusframework.message.processor.xml.XpathMessageProcessorBuilder;
import org.citrusframework.validation.DelegatingPayloadVariableExtractor;
import org.citrusframework.validation.GenericValidationProcessor;
import org.citrusframework.validation.interceptor.BinaryMessageProcessor;
import org.citrusframework.validation.interceptor.GzipMessageProcessor;
import org.citrusframework.variable.MessageHeaderVariableExtractor;
import org.citrusframework.variable.json.JsonPathVariableExtractorBuilder;
import org.citrusframework.variable.xml.XpathPayloadVariableExtractorBuilder;

public interface MessageProcessorSupport
extends Processors,
MessageProcessorLookupSupport {
    default public BinaryMessageProcessor.Builder toBinary() {
        return new BinaryMessageProcessor.Builder();
    }

    default public DelegatingPathExpressionProcessor.Builder path() {
        return new DelegatingPathExpressionProcessor.Builder();
    }

    default public DelegatingVariableExtractorBuilder extract() {
        return new DelegatingVariableExtractorBuilder(){

            public DelegatingPayloadVariableExtractor.Builder fromBody() {
                return new DelegatingPayloadVariableExtractor.Builder();
            }

            public MessageHeaderVariableExtractor.Builder fromHeaders() {
                return new MessageHeaderVariableExtractor.Builder();
            }
        };
    }

    default public GzipMessageProcessor.Builder toGzip() {
        return new GzipMessageProcessor.Builder();
    }

    default public CamelMessageProcessors camel() {
        return (CamelMessageProcessors)this.lookup("camel", new Object[0]);
    }

    default public JsonMessageProcessors json() {
        return new JsonMessageProcessors(){

            public JsonPathMessageProcessorBuilder<?, ?> jsonPath() {
                return (JsonPathMessageProcessorBuilder)MessageProcessorSupport.this.lookup("jsonPath", new Object[0]);
            }

            public JsonPathVariableExtractorBuilder<?, ?> extract() {
                return (JsonPathVariableExtractorBuilder)MessageProcessorSupport.this.lookup("jsonExtract", new Object[0]);
            }

            public <T> JsonMappingValidationProcessorBuilder<T, ?, ?> validate(Class<T> type) {
                return (JsonMappingValidationProcessorBuilder)MessageProcessorSupport.this.lookup("jsonValidate", new Object[]{type});
            }
        };
    }

    default public XmlMessageProcessors xml() {
        return new XmlMessageProcessors(){

            public XpathMessageProcessorBuilder<?, ?> xpath() {
                return (XpathMessageProcessorBuilder)MessageProcessorSupport.this.lookup("xpath", new Object[0]);
            }

            public XpathPayloadVariableExtractorBuilder<?, ?> extract() {
                return (XpathPayloadVariableExtractorBuilder)MessageProcessorSupport.this.lookup("xpathExtract", new Object[0]);
            }

            public <T> XmlMarshallingValidationProcessorBuilder<T, ?, ?> validate(GenericValidationProcessor<T> validationProcessor) {
                return (XmlMarshallingValidationProcessorBuilder)MessageProcessorSupport.this.lookup("xmlValidate", new Object[]{validationProcessor});
            }
        };
    }
}

