/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.log;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.citrusframework.log.CitrusLogSettings;
import org.citrusframework.log.LogMessageModifier;
import org.citrusframework.util.IsJsonPredicate;
import org.citrusframework.util.IsXmlPredicate;
import org.citrusframework.util.IsYamlPredicate;

public class DefaultLogModifier
implements LogMessageModifier {
    private final Set<String> keywords = CitrusLogSettings.getLogMaskKeywords();
    private final String logMaskValue = CitrusLogSettings.getLogMaskValue();
    private boolean maskXml = CitrusLogSettings.isMaskXmlEnabled();
    private boolean maskJson = CitrusLogSettings.isMaskJsonEnabled();
    private boolean maskYaml = CitrusLogSettings.isMaskYamlEnabled();
    private boolean maskKeyValue = CitrusLogSettings.isMaskKeyValueEnabled();
    private boolean maskFormUrlEncoded = CitrusLogSettings.isMaskFormUrlEncodedEnabled();
    private Pattern keyValuePattern;
    private Pattern xmlPattern;
    private Pattern jsonPattern;
    private Pattern yamlPattern;
    private Pattern formUrlEncodedPattern;

    public String mask(String source) {
        if (!CitrusLogSettings.isLogModifierEnabled() || source == null || source.isEmpty()) {
            return source;
        }
        boolean xml = this.maskXml && IsXmlPredicate.getInstance().test(source);
        boolean json = this.maskJson && !xml && IsJsonPredicate.getInstance().test(source);
        boolean yaml = this.maskYaml && !xml && !json && IsYamlPredicate.getInstance().test(source);
        boolean formUrlEncoded = this.maskFormUrlEncoded && !yaml && source.contains("&") && source.contains("=");
        String masked = source;
        if (xml) {
            masked = this.createXmlPattern(this.keywords).matcher(masked).replaceAll("$1" + this.logMaskValue + "$2");
            if (this.maskKeyValue) {
                masked = this.createKeyValuePattern(this.keywords).matcher(masked).replaceAll("$1" + this.logMaskValue);
            }
        } else if (json) {
            masked = this.createJsonPattern(this.keywords).matcher(masked).replaceAll("$1\"" + this.logMaskValue + "\"");
        } else if (yaml) {
            masked = this.createYamlPattern(this.keywords).matcher(masked).replaceAll("$1" + this.logMaskValue);
        } else if (formUrlEncoded) {
            masked = this.createFormUrlEncodedPattern(this.keywords).matcher(masked).replaceAll("$1" + this.logMaskValue);
        } else if (this.maskKeyValue) {
            masked = this.createKeyValuePattern(this.keywords).matcher(masked).replaceAll("$1" + this.logMaskValue);
        }
        return masked;
    }

    protected Pattern createKeyValuePattern(Set<String> keywords) {
        if (this.keyValuePattern == null) {
            String keywordExpression = this.createKeywordsExpression(keywords);
            if (keywordExpression.isEmpty()) {
                return null;
            }
            String regex = "((?>" + keywordExpression + ")\\s*=\\s*['\"]?)([^,'\"]+)";
            this.keyValuePattern = Pattern.compile(regex, 2);
        }
        return this.keyValuePattern;
    }

    protected Pattern createFormUrlEncodedPattern(Set<String> keywords) {
        if (this.formUrlEncodedPattern == null) {
            String keywordExpression = this.createKeywordsExpression(keywords);
            if (keywordExpression.isEmpty()) {
                return null;
            }
            String regex = "((?>" + keywordExpression + ")\\s*=\\s*)([^&]*)";
            this.formUrlEncodedPattern = Pattern.compile(regex, 2);
        }
        return this.formUrlEncodedPattern;
    }

    protected Pattern createXmlPattern(Set<String> keywords) {
        if (this.xmlPattern == null) {
            String keywordExpression = this.createKeywordsExpression(keywords);
            if (keywordExpression.isEmpty()) {
                return null;
            }
            String regex = "(<(?>" + keywordExpression + ")>)[^<]*(</(?>" + keywordExpression + ")>)";
            this.xmlPattern = Pattern.compile(regex, 2);
        }
        return this.xmlPattern;
    }

    protected Pattern createJsonPattern(Set<String> keywords) {
        if (this.jsonPattern == null) {
            String keywordExpression = this.createKeywordsExpression(keywords);
            if (keywordExpression.isEmpty()) {
                return null;
            }
            String regex = "(\"(?>" + keywordExpression + ")\"\\s*:\\s*)(\"?[^\",]*[\",])";
            this.jsonPattern = Pattern.compile(regex, 2);
        }
        return this.jsonPattern;
    }

    protected Pattern createYamlPattern(Set<String> keywords) {
        if (this.yamlPattern == null) {
            String keywordExpression = this.createKeywordsExpression(keywords);
            if (keywordExpression.isEmpty()) {
                return null;
            }
            String regex = "((?>" + keywordExpression + "):\\s*['\"]?)([^'\"]+)";
            this.yamlPattern = Pattern.compile(regex, 2);
        }
        return this.yamlPattern;
    }

    protected String createKeywordsExpression(Set<String> keywords) {
        if (keywords == null || keywords.isEmpty()) {
            return "";
        }
        return keywords.stream().map(Pattern::quote).collect(Collectors.joining("|"));
    }

    public void setMaskJson(boolean maskJson) {
        this.maskJson = maskJson;
    }

    public void setMaskYaml(boolean maskYaml) {
        this.maskYaml = maskYaml;
    }

    public void setMaskXml(boolean maskXml) {
        this.maskXml = maskXml;
    }

    public void setMaskKeyValue(boolean maskKeyValue) {
        this.maskKeyValue = maskKeyValue;
    }

    public void setMaskFormUrlEncoded(boolean maskFormUrlEncoded) {
        this.maskFormUrlEncoded = maskFormUrlEncoded;
    }
}

