/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint.resolver;

import java.util.Map;
import java.util.StringTokenizer;
import org.citrusframework.endpoint.resolver.EndpointUriResolver;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.util.StringUtils;

public class DynamicEndpointUriResolver
implements EndpointUriResolver {
    private String defaultEndpointUri;

    public String resolveEndpointUri(Message message, String defaultUri) {
        Map headers = message.getHeaders();
        String requestUri = headers.containsKey("citrus_endpoint_uri") ? headers.get("citrus_endpoint_uri").toString() : (StringUtils.hasText(defaultUri) ? defaultUri : this.defaultEndpointUri);
        if (requestUri == null) {
            throw new CitrusRuntimeException("Unable to resolve dynamic endpoint uri! Neither header entry 'citrus_endpoint_uri' nor default endpoint uri is set");
        }
        requestUri = this.appendRequestPath(requestUri, headers);
        requestUri = this.appendQueryParams(requestUri, headers);
        return requestUri;
    }

    private String appendRequestPath(String uri, Map<String, Object> headers) {
        if (!headers.containsKey("citrus_request_path")) {
            return uri;
        }
        String requestUri = uri;
        String path = headers.get("citrus_request_path").toString();
        while (requestUri.endsWith("/")) {
            requestUri = requestUri.substring(0, requestUri.length() - 1);
        }
        while (path.startsWith("/") && !path.isEmpty()) {
            path = path.length() == 1 ? "" : path.substring(1);
        }
        return requestUri + "/" + path;
    }

    private String appendQueryParams(String uri, Map<String, Object> headers) {
        if (!headers.containsKey("citrus_query_params")) {
            return uri;
        }
        String requestUri = uri;
        StringBuilder queryParamBuilder = new StringBuilder();
        String queryParams = headers.get("citrus_query_params").toString();
        StringTokenizer tok = new StringTokenizer(queryParams, ",");
        if (tok.hasMoreTokens()) {
            while (requestUri.endsWith("/")) {
                requestUri = requestUri.substring(0, requestUri.length() - 1);
            }
            queryParamBuilder.append("?").append(tok.nextToken());
        }
        while (tok.hasMoreTokens()) {
            queryParamBuilder.append("&").append(tok.nextToken());
        }
        return requestUri + queryParamBuilder;
    }

    public void setDefaultEndpointUri(String defaultEndpointUri) {
        this.defaultEndpointUri = defaultEndpointUri;
    }
}

