/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint;

import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpoint;
import org.citrusframework.endpoint.AbstractEndpointConfiguration;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.message.Message;
import org.citrusframework.messaging.Consumer;
import org.citrusframework.messaging.Producer;

public class StaticEndpoint
extends AbstractEndpoint {
    private Message message;

    public StaticEndpoint() {
        this(new StaticEndpointConfiguration());
    }

    public StaticEndpoint(Message message) {
        this(message, new StaticEndpointConfiguration());
    }

    public StaticEndpoint(StaticEndpointConfiguration endpointConfiguration) {
        this(new DefaultMessage(""), endpointConfiguration);
    }

    public StaticEndpoint(Message message, StaticEndpointConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
        this.message = message;
    }

    public Producer createProducer() {
        return new Producer(){

            public void send(Message message, TestContext context) {
            }

            public String getName() {
                return StaticEndpoint.this.getName() + "-producer";
            }
        };
    }

    public Consumer createConsumer() {
        return new Consumer(){

            public Message receive(TestContext context) {
                return StaticEndpoint.this.getMessage();
            }

            public Message receive(TestContext context, long timeout) {
                return StaticEndpoint.this.getMessage();
            }

            public String getName() {
                return StaticEndpoint.this.getName() + "-consumer";
            }
        };
    }

    public StaticEndpointConfiguration getEndpointConfiguration() {
        return (StaticEndpointConfiguration)super.getEndpointConfiguration();
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Message getMessage() {
        if (this.getEndpointConfiguration().isReuseMessage()) {
            return this.message;
        }
        return new DefaultMessage(this.message, true);
    }

    public static class StaticEndpointConfiguration
    extends AbstractEndpointConfiguration {
        private boolean reuseMessage = true;

        public boolean isReuseMessage() {
            return this.reuseMessage;
        }

        public void setReuseMessage(boolean reuseMessage) {
            this.reuseMessage = reuseMessage;
        }
    }
}

