/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import org.citrusframework.CitrusSettings;
import org.citrusframework.common.ShutdownPhase;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointComponent;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.ReflectionHelper;
import org.citrusframework.util.TypeConversionUtils;

public abstract class AbstractEndpointComponent
implements EndpointComponent {
    private final String name;

    public AbstractEndpointComponent(String name) {
        this.name = name;
    }

    public Endpoint createEndpoint(String endpointUri, TestContext context) {
        try {
            boolean autoClose;
            Map<String, String> parameters;
            Endpoint endpoint;
            URI uri = new URI(AbstractEndpointComponent.resolveEndpointUri(endpointUri));
            String path = uri.getSchemeSpecificPart();
            if (path.startsWith("//")) {
                path = path.substring(2);
            }
            if (path.contains("?")) {
                path = path.substring(0, path.indexOf(63));
            }
            if ((endpoint = this.createEndpoint(path, this.getEndpointParameters(parameters = this.getParameters(endpointUri)), context)) instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)endpoint).setReferenceResolver(context.getReferenceResolver());
            }
            if (parameters.containsKey("endpointName")) {
                endpoint.setName(parameters.get("endpointName"));
            }
            if (autoClose = Optional.ofNullable(parameters.get("autoClose")).map(Boolean::parseBoolean).orElseGet(CitrusSettings::isAutoCloseDynamicEndpoints).booleanValue()) {
                context.doFinally(() -> ctx -> {
                    if (endpoint instanceof ShutdownPhase) {
                        ShutdownPhase destroyable = (ShutdownPhase)endpoint;
                        logger.info("Stopping endpoint '{}' due to auto close setting", (Object)endpoint.getName());
                        destroyable.destroy();
                    }
                });
            }
            return endpoint;
        }
        catch (URISyntaxException e) {
            throw new CitrusRuntimeException(String.format("Unable to parse endpoint uri '%s'", endpointUri), (Throwable)e);
        }
    }

    private Map<String, String> getEndpointParameters(Map<String, String> parameters) {
        Set<String> internalSettings = Set.of("endpointName", "autoClose", "autoRemove");
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : parameters.keySet()) {
            if (internalSettings.contains(key)) continue;
            result.put(key, parameters.get(key));
        }
        return result;
    }

    public Map<String, String> getParameters(String endpointUri) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (endpointUri.contains("?")) {
            String parameterString = endpointUri.substring(endpointUri.indexOf(63) + 1);
            StringTokenizer tok = new StringTokenizer(parameterString, "&");
            while (tok.hasMoreElements()) {
                Object[] parameterValue = tok.nextToken().split("=");
                if (parameterValue.length == 1) {
                    parameters.put(parameterValue[0], null);
                    continue;
                }
                if (parameterValue.length == 2) {
                    parameters.put(parameterValue[0], parameterValue[1]);
                    continue;
                }
                throw new CitrusRuntimeException(String.format("Invalid parameter key/value combination '%s'", Arrays.toString(parameterValue)));
            }
        }
        return parameters;
    }

    protected void enrichEndpointConfiguration(EndpointConfiguration endpointConfiguration, Map<String, String> parameters, TestContext context) {
        for (Map.Entry<String, String> parameterEntry : parameters.entrySet()) {
            Field field = ReflectionHelper.findField(endpointConfiguration.getClass(), (String)parameterEntry.getKey());
            if (field == null) {
                throw new CitrusRuntimeException(String.format("Unable to find parameter field on endpoint configuration '%s'", parameterEntry.getKey()));
            }
            Method setter = ReflectionHelper.findMethod(endpointConfiguration.getClass(), (String)("set" + parameterEntry.getKey().substring(0, 1).toUpperCase() + parameterEntry.getKey().substring(1)), (Class[])new Class[]{field.getType()});
            if (setter == null) {
                throw new CitrusRuntimeException(String.format("Unable to find parameter setter on endpoint configuration '%s'", "set" + parameterEntry.getKey().substring(0, 1).toUpperCase() + parameterEntry.getKey().substring(1)));
            }
            if (parameterEntry.getValue() != null) {
                ReflectionHelper.invokeMethod((Method)setter, (Object)endpointConfiguration, (Object[])new Object[]{TypeConversionUtils.convertStringToType((String)parameterEntry.getValue(), field.getType(), (TestContext)context)});
                continue;
            }
            ReflectionHelper.invokeMethod((Method)setter, (Object)endpointConfiguration, (Object[])new Object[]{field.getType().cast(null)});
        }
    }

    protected Map<String, String> getEndpointConfigurationParameters(Map<String, String> parameters, Class<? extends EndpointConfiguration> endpointConfigurationType) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, String> parameterEntry : parameters.entrySet()) {
            Field field = ReflectionHelper.findField(endpointConfigurationType, (String)parameterEntry.getKey());
            if (field == null) continue;
            params.put(parameterEntry.getKey(), parameterEntry.getValue());
        }
        return params;
    }

    protected String getParameterString(Map<String, String> parameters, Class<? extends EndpointConfiguration> endpointConfigurationType) {
        StringBuilder paramString = new StringBuilder();
        for (Map.Entry<String, String> parameterEntry : parameters.entrySet()) {
            Field field = ReflectionHelper.findField(endpointConfigurationType, (String)parameterEntry.getKey());
            if (field != null) continue;
            if (paramString.isEmpty()) {
                paramString.append("?").append(parameterEntry.getKey());
            } else {
                paramString.append("&").append(parameterEntry.getKey());
            }
            if (parameterEntry.getValue() == null) continue;
            paramString.append("=").append(parameterEntry.getValue());
        }
        return paramString.toString();
    }

    private static String resolveEndpointUri(String endpointUri) {
        if (endpointUri.contains("?")) {
            String[] tokens = endpointUri.split("\\?", 2);
            return tokens[0] + "?" + URLEncoder.encode(tokens[1], StandardCharsets.UTF_8);
        }
        return endpointUri;
    }

    protected abstract Endpoint createEndpoint(String var1, Map<String, String> var2, TestContext var3);

    public String getName() {
        return this.name;
    }
}

