/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.AbstractTestContainerBuilder;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.container.AbstractActionContainer;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSuiteActionContainer
extends AbstractActionContainer
implements ReferenceResolverAware {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSuiteActionContainer.class);
    private List<String> suiteNames = new ArrayList<String>();
    private List<String> testGroups = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();
    private Map<String, String> systemProperties = new HashMap<String, String>();

    protected AbstractSuiteActionContainer(String name, AbstractTestContainerBuilder<?, ?> builder) {
        super(name, builder);
    }

    public boolean shouldExecute(String suiteName, String[] includedGroups) {
        String baseErrorMessage = "Skip before/after suite container because of %s restriction - do not execute container '%s'";
        if (StringUtils.hasText(suiteName) && this.suiteNames != null && !this.suiteNames.isEmpty() && !this.suiteNames.contains(suiteName)) {
            logger.warn("{} suite name {}", (Object)baseErrorMessage, (Object)this.getName());
            return false;
        }
        if (!this.checkTestGroups(includedGroups)) {
            logger.warn("{} test groups {}", (Object)baseErrorMessage, (Object)this.getName());
            return false;
        }
        for (Map.Entry<String, String> envEntry : this.env.entrySet()) {
            if (System.getenv().containsKey(envEntry.getKey()) && (!StringUtils.hasText(envEntry.getValue()) || System.getenv().get(envEntry.getKey()).equals(envEntry.getValue()))) continue;
            logger.warn("{} env properties {}", (Object)baseErrorMessage, (Object)this.getName());
            return false;
        }
        for (Map.Entry<String, String> systemProperty : this.systemProperties.entrySet()) {
            if (System.getProperties().containsKey(systemProperty.getKey()) && (!StringUtils.hasText(systemProperty.getValue()) || System.getProperties().get(systemProperty.getKey()).equals(systemProperty.getValue()))) continue;
            logger.warn("{} system properties {}", (Object)baseErrorMessage, (Object)this.getName());
            return false;
        }
        return true;
    }

    private boolean checkTestGroups(String[] includedGroups) {
        if (this.testGroups.isEmpty()) {
            return true;
        }
        if (includedGroups != null) {
            for (String includedGroup : includedGroups) {
                if (!this.testGroups.contains(includedGroup)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getTestGroups() {
        return this.testGroups;
    }

    public void setTestGroups(List<String> testGroups) {
        this.testGroups = testGroups;
    }

    public List<String> getSuiteNames() {
        return this.suiteNames;
    }

    public void setSuiteNames(List<String> suiteNames) {
        this.suiteNames = suiteNames;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        for (TestActionBuilder builder : this.actions) {
            if (!(builder instanceof ReferenceResolverAware)) continue;
            ReferenceResolverAware referenceResolverAwareBuilder = (ReferenceResolverAware)builder;
            referenceResolverAwareBuilder.setReferenceResolver(referenceResolver);
        }
    }
}

