/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.citrusframework.Citrus;
import org.citrusframework.CitrusContext;
import org.citrusframework.DefaultTestActions;
import org.citrusframework.GherkinTestActionRunner;
import org.citrusframework.TestActionRunner;
import org.citrusframework.TestActionSupport;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusConfiguration;
import org.citrusframework.annotations.CitrusEndpointAnnotations;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.common.Named;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.BindToRegistry;
import org.citrusframework.spi.ReferenceRegistry;
import org.citrusframework.util.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CitrusAnnotations {
    private static final Logger logger = LoggerFactory.getLogger(CitrusAnnotations.class);

    private CitrusAnnotations() {
    }

    public static void injectAll(Object target) {
        CitrusAnnotations.injectAll(target, Citrus.newInstance());
    }

    public static void injectAll(Object target, Citrus citrusFramework) {
        CitrusAnnotations.injectAll(target, citrusFramework, citrusFramework.getCitrusContext().createTestContext());
    }

    public static void injectAll(Object target, Citrus citrusFramework, TestContext context) {
        CitrusAnnotations.injectCitrusFramework(target, citrusFramework);
        CitrusContext citrusContext = citrusFramework.getCitrusContext();
        CitrusAnnotations.injectCitrusContext(target, citrusContext);
        citrusContext.parseConfiguration(target);
        CitrusAnnotations.injectEndpoints(target, context);
        CitrusAnnotations.injectTestContext(target, context);
        CitrusAnnotations.injectTestActionBuilder(target);
    }

    public static void injectEndpoints(Object target, TestContext context) {
        CitrusEndpointAnnotations.injectEndpoints((Object)target, (TestContext)context);
    }

    public static void injectCitrusFramework(Object testCase, Citrus citrusFramework) {
        ReflectionHelper.doWithFields(testCase.getClass(), field -> {
            if (!field.isAnnotationPresent(CitrusFramework.class) || !Citrus.class.isAssignableFrom(field.getType())) {
                return;
            }
            logger.trace("Injecting Citrus framework instance on test class field '{}'", (Object)field.getName());
            ReflectionHelper.setField((Field)field, (Object)testCase, (Object)citrusFramework);
        });
    }

    public static void injectCitrusContext(Object target, CitrusContext context) {
        ReflectionHelper.doWithFields(target.getClass(), field -> {
            if (!field.isAnnotationPresent(CitrusResource.class) || !CitrusContext.class.isAssignableFrom(field.getType())) {
                return;
            }
            logger.trace("Injecting Citrus context instance on test class field '{}'", (Object)field.getName());
            ReflectionHelper.setField((Field)field, (Object)target, (Object)context);
        });
    }

    public static void injectTestContext(Object target, TestContext context) {
        ReflectionHelper.doWithFields(target.getClass(), field -> {
            if (!field.isAnnotationPresent(CitrusResource.class) || !TestContext.class.isAssignableFrom(field.getType())) {
                return;
            }
            Class<?> type = field.getType();
            if (!TestContext.class.isAssignableFrom(type)) {
                throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + type);
            }
            logger.trace("Injecting test context instance on test class field '{}'", (Object)field.getName());
            ReflectionHelper.setField((Field)field, (Object)target, (Object)context);
        });
    }

    public static void injectTestActionBuilder(Object target) {
        ReflectionHelper.doWithFields(target.getClass(), field -> {
            if (!field.isAnnotationPresent(CitrusResource.class) || !TestActionSupport.class.isAssignableFrom(field.getType())) {
                return;
            }
            Class<?> type = field.getType();
            if (!TestActionSupport.class.isAssignableFrom(type)) {
                throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + type);
            }
            logger.trace("Injecting test action builder instance on test class field '{}'", (Object)field.getName());
            ReflectionHelper.setField((Field)field, (Object)target, (Object)new DefaultTestActions());
        });
    }

    public static void injectTestRunner(Object target, TestCaseRunner runner) {
        ReflectionHelper.doWithFields(target.getClass(), field -> {
            if (!field.isAnnotationPresent(CitrusResource.class) || !TestCaseRunner.class.isAssignableFrom(field.getType())) {
                return;
            }
            Class<?> type = field.getType();
            if (!TestCaseRunner.class.isAssignableFrom(type)) {
                throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + type);
            }
            logger.trace("Injecting test runner instance on test class field '{}'", (Object)field.getName());
            ReflectionHelper.setField((Field)field, (Object)target, (Object)runner);
        });
        CitrusAnnotations.injectTestActionRunner(target, (TestActionRunner)runner);
        CitrusAnnotations.injectGherkinTestActionRunner(target, (GherkinTestActionRunner)runner);
    }

    private static void injectTestActionRunner(Object target, TestActionRunner runner) {
        ReflectionHelper.doWithFields(target.getClass(), field -> {
            if (!field.isAnnotationPresent(CitrusResource.class) || !TestActionRunner.class.isAssignableFrom(field.getType())) {
                return;
            }
            Class<?> type = field.getType();
            if (!TestActionRunner.class.isAssignableFrom(type)) {
                throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + type);
            }
            logger.trace("Injecting test action runner instance on test class field '{}'", (Object)field.getName());
            ReflectionHelper.setField((Field)field, (Object)target, (Object)runner);
        });
    }

    private static void injectGherkinTestActionRunner(Object target, GherkinTestActionRunner runner) {
        ReflectionHelper.doWithFields(target.getClass(), field -> {
            if (!field.isAnnotationPresent(CitrusResource.class) || !GherkinTestActionRunner.class.isAssignableFrom(field.getType())) {
                return;
            }
            Class<?> type = field.getType();
            if (!GherkinTestActionRunner.class.isAssignableFrom(type)) {
                throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + type);
            }
            logger.trace("Injecting test action runner instance on test class field '{}'", (Object)field.getName());
            ReflectionHelper.setField((Field)field, (Object)target, (Object)runner);
        });
    }

    public static void parseConfiguration(Class<?> configClass, CitrusContext citrusContext) {
        try {
            CitrusAnnotations.parseConfiguration(configClass.getConstructor(new Class[0]).newInstance(new Object[0]), citrusContext);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CitrusRuntimeException("Missing or non-accessible default constructor on custom configuration class", (Throwable)e);
        }
    }

    public static void parseConfiguration(Object configuration, CitrusContext citrusContext) {
        Class<?> configClass = configuration.getClass();
        if (configClass.isAnnotationPresent(CitrusConfiguration.class)) {
            for (Class type : configClass.getAnnotation(CitrusConfiguration.class).classes()) {
                citrusContext.parseConfiguration(type);
            }
        }
        Arrays.stream(configClass.getDeclaredMethods()).filter(m -> m.getAnnotation(BindToRegistry.class) != null).forEach(m -> {
            try {
                String name = ReferenceRegistry.getName((BindToRegistry)m.getAnnotation(BindToRegistry.class), (String)m.getName());
                Object component = m.invoke(configuration, new Object[0]);
                if (component == null) {
                    return;
                }
                if (component instanceof Named) {
                    Named named = (Named)component;
                    named.setName(name);
                }
                citrusContext.addComponent(name, component);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new CitrusRuntimeException("Failed to invoke configuration method", (Throwable)e);
            }
        });
        Arrays.stream(configClass.getDeclaredFields()).filter(f -> f.getAnnotation(BindToRegistry.class) != null).peek(f -> {
            if (!(Modifier.isPublic(f.getModifiers()) && Modifier.isPublic(f.getDeclaringClass().getModifiers()) && !Modifier.isFinal(f.getModifiers()) || f.isAccessible())) {
                f.setAccessible(true);
            }
        }).forEach(f -> {
            try {
                String name = ReferenceRegistry.getName((BindToRegistry)f.getAnnotation(BindToRegistry.class), (String)f.getName());
                Object component = f.get(configuration);
                if (component == null) {
                    return;
                }
                if (component instanceof Named) {
                    Named named = (Named)component;
                    named.setName(name);
                }
                citrusContext.addComponent(name, component);
            }
            catch (IllegalAccessException e) {
                throw new CitrusRuntimeException("Failed to access configuration field", (Throwable)e);
            }
        });
    }
}

