/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.actions.StopTimerActionBuilder;
import org.citrusframework.context.TestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopTimerAction
extends AbstractTestAction {
    private static final Logger logger = LoggerFactory.getLogger(StopTimerAction.class);
    private final String timerId;

    public StopTimerAction(Builder builder) {
        super("stop-timer", builder);
        this.timerId = builder.timerId;
    }

    public String getTimerId() {
        return this.timerId;
    }

    @Override
    public void doExecute(TestContext context) {
        if (this.timerId != null) {
            boolean success = context.stopTimer(this.timerId);
            logger.info("Stopping timer {} - stop successful: {}", (Object)this.timerId, (Object)success);
        } else {
            context.stopTimers();
            logger.info("Stopping all timers");
        }
    }

    public static final class Builder
    extends AbstractTestActionBuilder<StopTimerAction, Builder>
    implements StopTimerActionBuilder<StopTimerAction> {
        private String timerId;

        public static Builder stopTimer() {
            return new Builder();
        }

        public static Builder stopTimer(String timerId) {
            Builder builder = new Builder();
            builder.id(timerId);
            return builder;
        }

        public Builder id(String timerId) {
            this.timerId = timerId;
            return this;
        }

        public StopTimerAction build() {
            return new StopTimerAction(this);
        }
    }
}

