/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.sharding;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.citrusframework.sharding.ShardingConfiguration;

public final class Shard {
    private Shard() {
        throw new IllegalArgumentException("Utility class shall not be instantiated!");
    }

    public static <T> T[] createShard(T[] testCases) {
        return Shard.createShard(testCases, new ShardingConfiguration());
    }

    public static <T> T[] createShard(T[] testCases, ShardingConfiguration shardingConfiguration) {
        return Shard.createShard(Arrays.stream(testCases), shardingConfiguration).toList().toArray(size -> (Object[])Array.newInstance(testCases.getClass().getComponentType(), size));
    }

    public static <T> Stream<T> createShard(Stream<T> testCases) {
        return Shard.createShard(testCases, new ShardingConfiguration());
    }

    public static <T> Stream<T> createShard(Stream<T> testCases, ShardingConfiguration shardingConfiguration) {
        return Shard.createShard(testCases, shardingConfiguration, false);
    }

    public static <T> Stream<T> createShard(Stream<T> testCases, ShardingConfiguration shardingConfiguration, boolean parallel) {
        List itemList = testCases.collect(Collectors.toCollection(ArrayList::new));
        Random random = new Random(shardingConfiguration.getSeed());
        Collections.shuffle(itemList, random);
        int shardSize = (int)Math.ceil((double)itemList.size() / (double)shardingConfiguration.getTotalNumberOfShards());
        int startIndex = shardingConfiguration.getShardNumber() * shardSize;
        int endIndex = Math.min(itemList.size(), startIndex + shardSize);
        List shardedItems = itemList.subList(startIndex, endIndex);
        if (parallel) {
            return shardedItems.parallelStream();
        }
        return shardedItems.stream();
    }
}

