/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message.builder;

import java.io.IOException;
import java.nio.charset.Charset;
import org.citrusframework.CitrusSettings;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.MessageHeaderDataBuilder;
import org.citrusframework.util.FileUtils;

public class FileResourceHeaderDataBuilder
implements MessageHeaderDataBuilder {
    private final String charsetName;
    private final String resourcePath;

    public FileResourceHeaderDataBuilder(String resourcePath) {
        this(resourcePath, CitrusSettings.CITRUS_FILE_ENCODING);
    }

    public FileResourceHeaderDataBuilder(String resourcePath, String charsetName) {
        this.charsetName = charsetName;
        this.resourcePath = resourcePath;
    }

    public String buildHeaderData(TestContext context) {
        try {
            return context.replaceDynamicContentInString(FileUtils.readToString(FileUtils.getFileResource(this.resourcePath, context), Charset.forName(context.resolveDynamicValue(this.charsetName))));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read message header data resource", (Throwable)e);
        }
    }
}

