/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaml;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.citrusframework.yaml.YamlNodeStringBuilder;

public class YamlStringBuilder
implements YamlNodeStringBuilder {
    private final int initialIndent;
    private final StringBuilder builder = new StringBuilder();

    public YamlStringBuilder(int initialIndent) {
        this.initialIndent = initialIndent;
    }

    public YamlStringBuilder() {
        this.initialIndent = 0;
    }

    @Override
    public StringBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public YamlStringBuilder append(String yaml) {
        this.builder.append(yaml);
        return this;
    }

    @Override
    public YamlNodeStringBuilder applyIndent() {
        this.builder.append(" ".repeat(this.initialIndent));
        return this;
    }

    @Override
    public YamlNodeStringBuilder withArray() {
        return new YamlArrayBuilder(this);
    }

    @Override
    public YamlNodeStringBuilder closeArray() {
        return this;
    }

    @Override
    public YamlNodeStringBuilder withObject(String name) {
        this.applyIndent();
        this.builder.append(name).append(":\n");
        return new YamlObjectBuilder(this);
    }

    @Override
    public YamlNodeStringBuilder closeObject() {
        return this;
    }

    public String prettyPrint() {
        return this.builder.toString();
    }

    public String toString() {
        return this.builder.toString();
    }

    public class YamlArrayBuilder
    implements YamlNodeStringBuilder {
        private final YamlNodeStringBuilder parent;

        public YamlArrayBuilder(YamlNodeStringBuilder parent) {
            this.parent = parent;
        }

        @Override
        public StringBuilder getBuilder() {
            return this.parent.getBuilder();
        }

        @Override
        public YamlArrayBuilder applyIndent() {
            this.parent.applyIndent();
            YamlStringBuilder.this.builder.append("  ");
            return this;
        }

        @Override
        public YamlArrayBuilder append(String yaml) {
            YamlStringBuilder.this.builder.append("- ");
            List<String> lines = Arrays.asList(yaml.split("\n"));
            YamlStringBuilder.this.builder.append(lines.get(0)).append("\n");
            lines.stream().skip(1L).forEach(line -> {
                this.parent.applyIndent();
                YamlStringBuilder.this.builder.append((String)line).append("\n");
            });
            return this;
        }

        @Override
        public YamlNodeStringBuilder withObject(String name) {
            this.applyIndent();
            YamlStringBuilder.this.builder.append("- ").append(name).append(":\n");
            return new YamlObjectBuilder(this);
        }

        @Override
        public YamlNodeStringBuilder closeObject() {
            return this.parent;
        }

        @Override
        public YamlNodeStringBuilder withProperties(Map<String, Object> items) {
            items.forEach((key, value) -> {
                String stringValue;
                this.parent.applyIndent();
                YamlStringBuilder.this.builder.append("- name: \"").append((String)key).append("\"\n");
                this.applyIndent();
                if (value instanceof String && (stringValue = (String)value).contains("\"")) {
                    YamlStringBuilder.this.builder.append("value: |\n");
                    this.applyIndent();
                    YamlStringBuilder.this.builder.append("  ").append(value).append("\n");
                } else {
                    YamlStringBuilder.this.builder.append("value: \"").append(value).append("\"\n");
                }
            });
            return this;
        }

        @Override
        public YamlArrayBuilder withProperty(String name, String value) {
            return this;
        }

        @Override
        public YamlArrayBuilder withProperty(String name, long value) {
            return this;
        }

        @Override
        public YamlArrayBuilder withArray() {
            return new YamlArrayBuilder(this);
        }

        @Override
        public YamlNodeStringBuilder closeArray() {
            return this.parent;
        }
    }

    public class YamlObjectBuilder
    implements YamlNodeStringBuilder {
        private final YamlNodeStringBuilder parent;

        public YamlObjectBuilder(YamlNodeStringBuilder parent) {
            this.parent = parent;
        }

        @Override
        public StringBuilder getBuilder() {
            return this.parent.getBuilder();
        }

        @Override
        public YamlNodeStringBuilder applyIndent() {
            this.parent.applyIndent();
            YamlStringBuilder.this.builder.append("  ");
            return this;
        }

        @Override
        public YamlNodeStringBuilder append(String yaml) {
            List<String> lines = Arrays.asList(yaml.split("\n"));
            lines.forEach(line -> {
                this.applyIndent();
                YamlStringBuilder.this.builder.append((String)line).append("\n");
            });
            return this;
        }

        @Override
        public YamlNodeStringBuilder withObject(String name) {
            this.applyIndent();
            YamlStringBuilder.this.builder.append(name).append(":\n");
            return new YamlObjectBuilder(this);
        }

        @Override
        public YamlNodeStringBuilder closeObject() {
            return this.parent;
        }

        @Override
        public YamlNodeStringBuilder withArray() {
            return new YamlArrayBuilder(this);
        }

        @Override
        public YamlNodeStringBuilder closeArray() {
            return this.parent;
        }
    }
}

