/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.citrusframework.TestAction;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageStore
extends ConcurrentHashMap<String, Message>
implements MessageStore {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMessageStore.class);
    private final Map<String, String> registeredNames = new ConcurrentHashMap<String, String>();

    @Override
    public Message getMessage(String nameOrId) {
        if (this.registeredNames.containsKey(nameOrId)) {
            return (Message)super.get(this.registeredNames.get(nameOrId));
        }
        return (Message)super.get(nameOrId);
    }

    @Override
    public void storeMessage(String name, Message message) {
        if (this.registeredNames.containsKey(name)) {
            logger.warn("Message with name '{}' already exists in message store - will overwrite the name mapping", (Object)name);
        }
        this.registeredNames.put(name, message.getId());
        super.put(message.getId(), message);
    }

    @Override
    public String constructMessageName(TestAction action, Endpoint endpoint) {
        return action.getName() + "(" + endpoint.getName() + ")";
    }
}

