/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaml;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface SchemaProperty {
    public Kind kind() default Kind.PROPERTY;

    public String group() default "";

    public String name() default "";

    public String title() default "";

    public String description() default "";

    public TypeFormat format() default TypeFormat.NONE;

    public String defaultValue() default "";

    public double multipleOf() default 0.0;

    public double min() default 4.9E-324;

    public boolean exclusiveMin() default false;

    public double max() default 1.7976931348623157E308;

    public boolean exclusiveMax() default false;

    public int minLength() default 0;

    public int maxLength() default 0x7FFFFFFF;

    public String pattern() default "";

    public boolean required() default false;

    public boolean ignore() default false;

    public boolean advanced() default false;

    public MetaData[] metadata() default {};

    public static enum TypeFormat {
        NONE,
        STRING,
        NUMBER,
        BOOLEAN;

    }

    public static enum Kind {
        PROPERTY,
        ACTION,
        CONTAINER,
        ENDPOINT,
        FUNCTION,
        VALIDATION_MATCHER,
        GROUP;


        public String getCatalogKind() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case PROPERTY -> "";
                case ACTION -> "testAction";
                case CONTAINER -> "testContainer";
                case ENDPOINT -> "testEndpoint";
                case FUNCTION -> "testFunction";
                case VALIDATION_MATCHER -> "testValidationMatcher";
                case GROUP -> "testActionGroup";
            };
        }
    }

    public static @interface MetaData {
        public String key() default "";

        public String value() default "";
    }
}

