/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import org.citrusframework.exceptions.CitrusRuntimeException;

public class CachingInputStream
implements Supplier<InputStream> {
    private byte[] cache;
    private final InputStream original;

    public CachingInputStream(InputStream original) {
        this.original = original;
    }

    @Override
    public synchronized InputStream get() {
        if (this.cache == null) {
            try (InputStream inputStream = this.original;){
                this.cache = this.original.readAllBytes();
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read input stream", e);
            }
        }
        return new ByteArrayInputStream(this.cache);
    }
}

