/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.spi;

import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ClasspathResourceResolver;
import org.citrusframework.spi.PropertiesLoader;
import org.citrusframework.spi.TypeResolver;
import org.citrusframework.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePathTypeResolver
implements TypeResolver {
    @Nullable
    public static final URL ROOT = ResourcePathTypeResolver.class.getProtectionDomain().getCodeSource().getLocation();
    private static FileSystem rootFs = null;
    private static final Logger logger = LoggerFactory.getLogger(ResourcePathTypeResolver.class);
    private static final String INSTANCE = "INSTANCE";
    private final String resourceBasePath;
    private final ClasspathResourceResolver classpathResourceResolver = new ClasspathResourceResolver();
    private final List<String> zipEntriesAsString = Collections.synchronizedList(new ArrayList());
    private final Map<String, Properties> resourceProperties = new ConcurrentHashMap<String, Properties>();
    private final Map<String, Map<String, String>> typeCache = new ConcurrentHashMap<String, Map<String, String>>();

    private static boolean rootIsNotCitrusApiJar() {
        return Objects.nonNull(ROOT) && ROOT.toString().matches(".*jar(!/)?") && !ROOT.toString().replace("\\", "/").matches(".*/citrus-api-\\d+\\.\\d+\\.\\d+(-.*)?\\.jar");
    }

    public ResourcePathTypeResolver() {
        this("META-INF");
    }

    public ResourcePathTypeResolver(String resourceBasePath) {
        this.resourceBasePath = resourceBasePath.endsWith("/") ? resourceBasePath.substring(0, resourceBasePath.length() - 1) : resourceBasePath;
    }

    @Override
    public String resolveProperty(String resourcePath, String property) {
        return this.readAsProperties(resourcePath).getProperty(property);
    }

    @Override
    public <T> T resolve(String resourcePath, String property, Object ... initargs) {
        String cacheKey = this.toCacheKey(resourcePath, property, "NO_KEY_PROPERTY");
        Map map = this.typeCache.computeIfAbsent(cacheKey, key -> Collections.singletonMap(key, this.resolveProperty(resourcePath, property)));
        return this.instantiateType((String)map.get(cacheKey), initargs);
    }

    @Override
    public <T> Map<String, T> resolveAll(String path, String property, String keyProperty) {
        Map typeLookup = this.typeCache.computeIfAbsent(this.toCacheKey(path, property, keyProperty), key -> this.determineTypeLookup(path, property, keyProperty));
        HashMap resources = new HashMap();
        typeLookup.forEach((p, type) -> resources.put(p, this.instantiateType((String)type, new Object[0])));
        return resources;
    }

    private Map<String, String> determineTypeLookup(String path, String property, String keyProperty) {
        String fullPath = this.getFullResourcePath(path);
        HashMap<String, String> typeLookup = new HashMap<String, String>();
        try {
            Stream.concat(this.classpathResourceResolver.getResources(fullPath).stream().filter(Objects::nonNull), this.resolveAllFromJar(fullPath)).forEach(resourcePath -> {
                Path fileName = resourcePath.getFileName();
                if (fileName == null) {
                    logger.warn("Skip unsupported resource '{}' for resource lookup", resourcePath);
                    return;
                }
                if (property.equals("*")) {
                    Properties properties = this.readAsProperties(fullPath + "/" + fileName);
                    for (Map.Entry<Object, Object> prop : properties.entrySet()) {
                        String type = this.resolveProperty(fullPath + "/" + fileName, prop.getKey().toString());
                        typeLookup.put(fileName + "." + prop.getKey().toString(), type);
                    }
                } else {
                    String type = this.resolveProperty(fullPath + "/" + fileName, property);
                    if (keyProperty != null) {
                        typeLookup.put(this.resolveProperty(fullPath + "/" + fileName, keyProperty), type);
                    } else {
                        typeLookup.put(fileName.toString(), type);
                    }
                }
            });
        }
        catch (IOException e) {
            logger.warn("Failed to resolve resources in '{}'", (Object)fullPath, (Object)e);
        }
        return typeLookup;
    }

    private String toCacheKey(String path, String property, String keyProperty) {
        return path + "$$$" + property + "$$$" + keyProperty;
    }

    private Stream<Path> resolveAllFromJar(String path) {
        ClassLoader classLoader = ObjectHelper.assertNotNull(ResourcePathTypeResolver.class.getClassLoader());
        if (ResourcePathTypeResolver.rootIsNotCitrusApiJar() && Objects.nonNull(rootFs)) {
            return this.getZipEntries().stream().filter(entry -> entry.startsWith(path)).map(classLoader::getResource).filter(Objects::nonNull).map(entry -> {
                String[] split = entry.toString().split("!");
                try {
                    if (split.length > 1) {
                        return rootFs.getPath(split[1], new String[0]);
                    }
                    return Paths.get(entry.toURI());
                }
                catch (URISyntaxException e) {
                    logger.warn("Failed resolve resource from jar '{}'", entry, (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull);
        }
        return Stream.of(new Path[0]);
    }

    private synchronized List<String> getZipEntries() {
        if (this.zipEntriesAsString.isEmpty()) {
            try (ZipInputStream in = new ZipInputStream(ROOT.openStream());){
                ZipEntry entry;
                while ((entry = in.getNextEntry()) != null) {
                    this.zipEntriesAsString.add(entry.getName());
                }
            }
            catch (IOException e) {
                logger.warn("Failed to open '{}}'", (Object)ROOT, (Object)e);
            }
        }
        return this.zipEntriesAsString;
    }

    private Constructor<?> getConstructor(Class<?> type, Object[] initargs) {
        Object[] parameterTypes = this.getParameterTypes(initargs);
        Optional<Constructor> exactMatch = Arrays.stream(type.getDeclaredConstructors()).filter(arg_0 -> ResourcePathTypeResolver.lambda$getConstructor$6((Class[])parameterTypes, arg_0)).findFirst();
        if (exactMatch.isPresent()) {
            return exactMatch.get();
        }
        Optional<Constructor> match = Arrays.stream(type.getDeclaredConstructors()).filter(arg_0 -> ResourcePathTypeResolver.lambda$getConstructor$7((Class[])parameterTypes, arg_0)).findFirst();
        if (match.isPresent()) {
            return match.get();
        }
        throw new IllegalArgumentException(String.format("No matching constructor found for type %s and parameters %s", type.getName(), Arrays.toString(parameterTypes)));
    }

    private Properties readAsProperties(String resourcePath) {
        return this.resourceProperties.computeIfAbsent(resourcePath, k -> {
            String path = this.getFullResourcePath(resourcePath);
            return PropertiesLoader.loadProperties(path);
        });
    }

    private String getFullResourcePath(String resourcePath) {
        if (resourcePath == null || resourcePath.isEmpty()) {
            return this.resourceBasePath;
        }
        if (!resourcePath.startsWith(this.resourceBasePath)) {
            return this.resourceBasePath + "/" + resourcePath;
        }
        return resourcePath;
    }

    private Class<?>[] getParameterTypes(Object ... initargs) {
        return (Class[])Arrays.stream(initargs).map(Object::getClass).toArray(Class[]::new);
    }

    public <T> T instantiateType(String type, Object ... initargs) {
        try {
            if (initargs.length == 0) {
                return (T)Class.forName(type).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (T)this.getConstructor(Class.forName(type), initargs).newInstance(initargs);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            try {
                if (Arrays.stream(Class.forName(type).getFields()).anyMatch(field -> field.getName().equals(INSTANCE) && Modifier.isStatic(field.getModifiers()))) {
                    return (T)Class.forName(type).getField(INSTANCE).get(null);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e1) {
                throw new CitrusRuntimeException(String.format("Failed to resolve classpath resource of type '%s' - caused by: %s", type, Optional.ofNullable(e1.getMessage()).orElse(e1.getClass().getName())), e1);
            }
            logger.warn("Neither static instance nor accessible default constructor ({}) is given on type '{}'", (Object)Arrays.toString(this.getParameterTypes(initargs)), (Object)type);
            throw new CitrusRuntimeException(String.format("Failed to resolve classpath resource of type '%s' - caused by: %s", type, Optional.ofNullable(e.getMessage()).orElse(e.getClass().getName())), e);
        }
    }

    private static Class<?>[] replacePrimitiveTypes(Constructor<?> constructor) {
        Class<?>[] constructorParameters = constructor.getParameterTypes();
        for (int i = 0; i < constructorParameters.length; ++i) {
            if (constructorParameters[i] == Integer.TYPE) {
                constructorParameters[i] = Integer.class;
                continue;
            }
            if (constructorParameters[i] == Short.TYPE) {
                constructorParameters[i] = Short.class;
                continue;
            }
            if (constructorParameters[i] == Double.TYPE) {
                constructorParameters[i] = Double.class;
                continue;
            }
            if (constructorParameters[i] == Float.TYPE) {
                constructorParameters[i] = Float.class;
                continue;
            }
            if (constructorParameters[i] == Character.TYPE) {
                constructorParameters[i] = Character.class;
                continue;
            }
            if (constructorParameters[i] != Boolean.TYPE) continue;
            constructorParameters[i] = Boolean.class;
        }
        return constructorParameters;
    }

    private static /* synthetic */ boolean lambda$getConstructor$7(Class[] parameterTypes, Constructor constructor) {
        if (constructor.getParameterCount() != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (constructor.getParameterTypes()[i].isAssignableFrom(parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getConstructor$6(Class[] parameterTypes, Constructor constructor) {
        return Arrays.equals(ResourcePathTypeResolver.replacePrimitiveTypes(constructor), parameterTypes);
    }

    static {
        if (ResourcePathTypeResolver.rootIsNotCitrusApiJar()) {
            try {
                rootFs = FileSystems.newFileSystem(new File(ROOT.toString().substring("file:".length())).toPath());
            }
            catch (IOException e) {
                logger.debug("Failed to create File system from jar '{}'", (Object)ROOT, (Object)e);
            }
        }
    }
}

