/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message;

import org.citrusframework.CitrusSettings;
import org.citrusframework.util.IsJsonPredicate;
import org.citrusframework.util.IsXmlPredicate;
import org.citrusframework.util.IsYamlPredicate;

public class MessagePayloadUtils {
    private static final boolean prettyPrint = CitrusSettings.isPrettyPrintEnabled();

    private MessagePayloadUtils() {
    }

    public static String prettyPrint(String payload) {
        if (!prettyPrint) {
            return payload;
        }
        if (MessagePayloadUtils.isXml(payload)) {
            return MessagePayloadUtils.prettyPrintXml(payload);
        }
        if (MessagePayloadUtils.isJson(payload)) {
            return MessagePayloadUtils.prettyPrintJson(payload);
        }
        return payload;
    }

    public static boolean isXml(String payload) {
        return IsXmlPredicate.getInstance().test(payload);
    }

    public static boolean isJson(String payload) {
        return IsJsonPredicate.getInstance().test(payload);
    }

    public static boolean isYaml(String payload) {
        return IsYamlPredicate.getInstance().test(payload);
    }

    public static String prettyPrintXml(String payload) {
        boolean singleLine = true;
        int indentNum = 2;
        int indent = 0;
        String s = payload.trim();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char currentChar = s.charAt(i);
            if (currentChar == '<') {
                char nextChar = s.charAt(i + 1);
                if (nextChar == '/') {
                    indent -= indentNum;
                }
                if (!singleLine) {
                    sb.append(" ".repeat(Math.max(0, indent)));
                }
                if (nextChar != '?' && nextChar != '!' && nextChar != '/') {
                    indent += indentNum;
                }
                singleLine = false;
            }
            sb.append(currentChar);
            if (currentChar != '>') continue;
            if (s.charAt(i - 1) == '/') {
                indent -= indentNum;
                sb.append(System.lineSeparator());
                continue;
            }
            int nextStartElementPos = s.indexOf(60, i);
            if (nextStartElementPos > i + 1) {
                String textBetweenElements = s.substring(i + 1, nextStartElementPos);
                if (textBetweenElements.replaceAll("\\s", "").isEmpty()) {
                    sb.append(System.lineSeparator());
                } else {
                    sb.append(textBetweenElements.trim());
                    singleLine = true;
                }
                i = nextStartElementPos - 1;
                continue;
            }
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public static String prettyPrintJson(String payload) {
        if (payload == null) {
            return "{}";
        }
        if ("{}".equals(payload.trim()) || "[]".equals(payload.trim())) {
            return payload.trim();
        }
        int indentNum = 2;
        int indent = 0;
        boolean inQuote = false;
        boolean isKey = true;
        String s = payload.trim();
        StringBuilder sb = new StringBuilder();
        char previousChar = '\u0000';
        for (char currentChar : s.toCharArray()) {
            switch (currentChar) {
                case '\"': {
                    if (!inQuote && isKey) {
                        sb.append(" ".repeat(Math.max(0, indent)));
                    }
                    inQuote = !inQuote;
                    sb.append(currentChar);
                    break;
                }
                case ':': {
                    if (inQuote) {
                        sb.append(currentChar);
                        break;
                    }
                    isKey = false;
                    sb.append(currentChar).append(" ");
                    break;
                }
                case ' ': {
                    if (!inQuote) break;
                    sb.append(currentChar);
                    break;
                }
                case '[': 
                case '{': {
                    if (inQuote) {
                        sb.append(currentChar);
                        break;
                    }
                    if (isKey) {
                        sb.append(" ".repeat(Math.max(0, indent)));
                    } else {
                        isKey = true;
                    }
                    sb.append(currentChar);
                    sb.append(System.lineSeparator());
                    indent += indentNum;
                    break;
                }
                case ']': 
                case '}': {
                    if (!inQuote) {
                        if (previousChar == '\"' || Character.isDigit(previousChar)) {
                            isKey = true;
                            sb.append(System.lineSeparator());
                        } else if (previousChar == '}' || previousChar == ']') {
                            sb.append(System.lineSeparator());
                        }
                        sb.append(" ".repeat(Math.max(0, indent -= indentNum)));
                    }
                    sb.append(currentChar);
                    break;
                }
                case ',': {
                    sb.append(currentChar);
                    if (inQuote) break;
                    isKey = true;
                    sb.append(System.lineSeparator());
                    break;
                }
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    if (!inQuote && System.lineSeparator().equals(String.valueOf(currentChar))) break;
                    sb.append(currentChar);
                }
            }
            if (!inQuote && (System.lineSeparator().equals(String.valueOf(currentChar)) || currentChar == 32)) continue;
            previousChar = currentChar;
        }
        return sb.toString();
    }
}

