/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.json;

import java.util.List;
import java.util.stream.Collectors;
import org.citrusframework.json.JsonNodeStringBuilder;
import org.citrusframework.message.MessagePayloadUtils;

public class JsonStringBuilder
implements JsonNodeStringBuilder {
    private final StringBuilder builder = new StringBuilder();

    @Override
    public JsonStringBuilder append(String json) {
        this.builder.append(json);
        return this;
    }

    @Override
    public JsonNodeStringBuilder withObject() {
        this.builder.append("{ ");
        return new JsonObjectBuilder(this);
    }

    @Override
    public JsonNodeStringBuilder closeObject() {
        this.builder.append(" }");
        return this;
    }

    @Override
    public JsonNodeStringBuilder withArray(List<String> items) {
        if (items.isEmpty()) {
            this.builder.append("[]");
        } else {
            this.builder.append("[ %s ]".formatted(items.stream().map(arg_0 -> JsonStringBuilder.lambda$withArray$0("\"%s\"", arg_0)).collect(Collectors.joining(","))));
        }
        return this;
    }

    @Override
    public JsonNodeStringBuilder withArray() {
        this.builder.append("[ ");
        return this;
    }

    @Override
    public JsonNodeStringBuilder closeArray() {
        this.builder.append(" ]");
        return this;
    }

    @Override
    public JsonNodeStringBuilder withProperty(String name) {
        return this;
    }

    @Override
    public JsonNodeStringBuilder withProperty(String name, long value) {
        return this;
    }

    @Override
    public JsonNodeStringBuilder withProperty(String name, String value) {
        return this;
    }

    public String prettyPrint() {
        return MessagePayloadUtils.prettyPrintJson(this.builder.toString());
    }

    public String toString() {
        return this.builder.toString();
    }

    private static /* synthetic */ String lambda$withArray$0(String rec$, Object xva$0) {
        return "\"%s\"".formatted(xva$0);
    }

    public class JsonObjectBuilder
    implements JsonNodeStringBuilder {
        boolean hasProperties = false;
        private final JsonNodeStringBuilder parent;

        public JsonObjectBuilder(JsonNodeStringBuilder parent) {
            this.parent = parent;
        }

        @Override
        public JsonNodeStringBuilder append(String json) {
            JsonStringBuilder.this.builder.append(json);
            return this;
        }

        @Override
        public JsonNodeStringBuilder withProperty(String name) {
            if (this.hasProperties) {
                JsonStringBuilder.this.builder.append(", ");
            }
            JsonStringBuilder.this.builder.append("\"%s\": ".formatted(name));
            this.hasProperties = true;
            return this;
        }

        @Override
        public JsonNodeStringBuilder withProperty(String name, String value) {
            if (this.hasProperties) {
                JsonStringBuilder.this.builder.append(", ");
            }
            JsonStringBuilder.this.builder.append("\"%s\": \"".formatted(name)).append(value).append("\"");
            this.hasProperties = true;
            return this;
        }

        @Override
        public JsonNodeStringBuilder withProperty(String name, long value) {
            if (this.hasProperties) {
                JsonStringBuilder.this.builder.append(", ");
            }
            JsonStringBuilder.this.builder.append("\"%s\": ".formatted(name)).append(value);
            this.hasProperties = true;
            return this;
        }

        @Override
        public JsonNodeStringBuilder withObject() {
            JsonStringBuilder.this.builder.append("{ ");
            return new JsonObjectBuilder(this);
        }

        @Override
        public JsonNodeStringBuilder closeObject() {
            JsonStringBuilder.this.builder.append(" }");
            return this.parent;
        }

        @Override
        public JsonNodeStringBuilder withArray(List<String> items) {
            if (items.isEmpty()) {
                JsonStringBuilder.this.builder.append("[]");
            } else {
                JsonStringBuilder.this.builder.append("[ %s ]".formatted(items.stream().map(arg_0 -> JsonObjectBuilder.lambda$withArray$0("\"%s\"", arg_0)).collect(Collectors.joining(","))));
            }
            return this;
        }

        @Override
        public JsonNodeStringBuilder withArray() {
            JsonStringBuilder.this.builder.append("[ ");
            return new JsonArrayBuilder(this);
        }

        @Override
        public JsonNodeStringBuilder closeArray() {
            JsonStringBuilder.this.builder.append(" ]");
            return this.parent;
        }

        private static /* synthetic */ String lambda$withArray$0(String rec$, Object xva$0) {
            return "\"%s\"".formatted(xva$0);
        }
    }

    public class JsonArrayBuilder
    implements JsonNodeStringBuilder {
        boolean hasItems = false;
        private final JsonNodeStringBuilder parent;

        public JsonArrayBuilder(JsonNodeStringBuilder parent) {
            this.parent = parent;
        }

        @Override
        public JsonNodeStringBuilder append(String json) {
            JsonStringBuilder.this.builder.append(json);
            return this;
        }

        @Override
        public JsonNodeStringBuilder withProperty(String name) {
            return this;
        }

        @Override
        public JsonNodeStringBuilder withProperty(String name, String value) {
            return this;
        }

        @Override
        public JsonNodeStringBuilder withProperty(String name, long value) {
            return this;
        }

        @Override
        public JsonNodeStringBuilder withObject() {
            if (this.hasItems) {
                JsonStringBuilder.this.builder.append(", ");
            }
            JsonStringBuilder.this.builder.append("{ ");
            this.hasItems = true;
            return new JsonObjectBuilder(this);
        }

        @Override
        public JsonNodeStringBuilder closeObject() {
            JsonStringBuilder.this.builder.append(" }");
            return this.parent;
        }

        @Override
        public JsonNodeStringBuilder withArray(List<String> items) {
            if (this.hasItems) {
                JsonStringBuilder.this.builder.append(", ");
            }
            if (items.isEmpty()) {
                JsonStringBuilder.this.builder.append("[]");
            } else {
                JsonStringBuilder.this.builder.append("[ %s ]".formatted(items.stream().map(arg_0 -> JsonArrayBuilder.lambda$withArray$0("\"%s\"", arg_0)).collect(Collectors.joining(","))));
            }
            this.hasItems = true;
            return this;
        }

        @Override
        public JsonNodeStringBuilder withArray() {
            if (this.hasItems) {
                JsonStringBuilder.this.builder.append(", ");
            }
            JsonStringBuilder.this.builder.append("[ ");
            this.hasItems = true;
            return new JsonArrayBuilder(this);
        }

        @Override
        public JsonNodeStringBuilder closeArray() {
            JsonStringBuilder.this.builder.append(" ]");
            return this.parent;
        }

        private static /* synthetic */ String lambda$withArray$0(String rec$, Object xva$0) {
            return "\"%s\"".formatted(xva$0);
        }
    }
}

