/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import java.nio.charset.StandardCharsets;
import org.citrusframework.context.TestContext;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.yaml.SchemaProperty;

public class TestSource {
    private String type;
    private String name;
    private String filePath;
    private Resource sourceFile;

    public TestSource(String type, String name) {
        this(type, name, "%s.%s".formatted(name, type));
    }

    public TestSource(String type, String name, String filePath) {
        this.type = type;
        this.name = name;
        this.filePath = filePath;
    }

    public TestSource(Class<?> testClass) {
        this("java", testClass.getName());
        String path = testClass.getPackageName().replace('.', '/');
        String fileName = testClass.getName() + ".java";
        this.sourceFile = new Resources.ClasspathResource(path.isEmpty() ? fileName : path + "/" + fileName);
    }

    public String getType() {
        return this.type;
    }

    @SchemaProperty(description="The test source type.")
    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    @SchemaProperty(description="The source file name.")
    public void setName(String name) {
        this.name = name;
    }

    public String getFilePath() {
        return this.filePath;
    }

    @SchemaProperty(description="The source file path.")
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Resource getSourceFile() {
        if (this.sourceFile == null) {
            this.sourceFile = Resources.create(this.filePath);
        }
        return this.sourceFile;
    }

    public Resource getSourceFile(TestContext context) {
        if (this.sourceFile == null) {
            this.sourceFile = Resources.create(context.replaceDynamicContentInString(this.filePath));
        }
        return this.sourceFile;
    }

    public void setSourceFile(Resource sourceFile) {
        this.sourceFile = sourceFile;
    }

    public TestSource sourceCode(String sourceCode) {
        this.sourceFile = new Resources.ByteArrayResource(sourceCode.getBytes(StandardCharsets.UTF_8));
        return this;
    }
}

