/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.util;

import java.util.HashMap;
import java.util.Map;
import org.citrusframework.CitrusSettings;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.citrusframework.util.DefaultTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TypeConverter {
    public static final Logger logger = LoggerFactory.getLogger(TypeConverter.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/type/converter";
    public static final Map<String, TypeConverter> converters = new HashMap<String, TypeConverter>();
    public static final String DEFAULT = "default";
    public static final String SPRING = "spring";
    public static final String APACHE_CAMEL = "camel";
    public static final String GROOVY = "groovy";

    public static Map<String, TypeConverter> lookup() {
        if (converters.isEmpty()) {
            converters.putAll(new ResourcePathTypeResolver().resolveAll(RESOURCE_PATH));
            if (converters.size() == 0) {
                converters.put(DEFAULT, DefaultTypeConverter.INSTANCE);
            }
            if (logger.isDebugEnabled()) {
                converters.forEach((k, v) -> logger.debug(String.format("Found type converter '%s' as %s", k, v.getClass())));
            }
        }
        return converters;
    }

    public static TypeConverter lookupDefault() {
        return TypeConverter.lookupDefault(DefaultTypeConverter.INSTANCE);
    }

    public static TypeConverter lookupDefault(TypeConverter defaultTypeConverter) {
        String name = CitrusSettings.getTypeConverter();
        Map<String, TypeConverter> converters = TypeConverter.lookup();
        if (converters.size() == 1) {
            Map.Entry<String, TypeConverter> converterEntry = converters.entrySet().iterator().next();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Using type converter '%s'", converterEntry.getKey()));
            }
            return converterEntry.getValue();
        }
        if (converters.containsKey(name)) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Using type converter '%s'", name));
            }
            return converters.get(name);
        }
        if (!DEFAULT.equals(name)) {
            logger.warn(String.format("Missing type converter for name '%s' - using default type converter", name));
        }
        return defaultTypeConverter;
    }

    public <T> T convertIfNecessary(Object var1, Class<T> var2);

    public <T> T convertStringToType(String var1, Class<T> var2);

    default public String asNormalizedArrayString(Object target) {
        return this.convertIfNecessary(target, String.class).replaceAll("^\\[", "").replaceAll("]$", "").replaceAll(",\\s", ",");
    }
}

