/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.citrusframework.report.TestSuiteListener;
import org.citrusframework.report.TestSuiteListenerAware;

public class TestSuiteListeners
implements TestSuiteListenerAware {
    private final List<TestSuiteListener> testSuiteListeners = new ArrayList<TestSuiteListener>();

    @Override
    public void addTestSuiteListener(TestSuiteListener testSuiteListener) {
        if (!this.testSuiteListeners.contains(testSuiteListener)) {
            this.testSuiteListeners.add(testSuiteListener);
        }
    }

    public void onFinish() {
        for (TestSuiteListener listener : this.testSuiteListeners) {
            listener.onFinish();
        }
    }

    public void onFinishFailure(Throwable cause) {
        for (TestSuiteListener listener : this.testSuiteListeners) {
            listener.onFinishFailure(cause);
        }
    }

    public void onFinishSuccess() {
        for (TestSuiteListener listener : this.testSuiteListeners) {
            listener.onFinishSuccess();
        }
    }

    public void onStart() {
        for (TestSuiteListener listener : this.testSuiteListeners) {
            listener.onStart();
        }
    }

    public void onStartFailure(Throwable cause) {
        for (TestSuiteListener listener : this.testSuiteListeners) {
            listener.onStartFailure(cause);
        }
    }

    public void onStartSuccess() {
        for (TestSuiteListener listener : this.testSuiteListeners) {
            listener.onStartSuccess();
        }
    }

    public List<TestSuiteListener> getTestSuiteListeners() {
        return Collections.unmodifiableList(this.testSuiteListeners);
    }
}

