/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.util.ArrayList;
import java.util.List;
import org.citrusframework.TestCase;
import org.citrusframework.report.TestListener;
import org.citrusframework.report.TestListenerAware;

public class TestListeners
implements TestListenerAware {
    private final List<TestListener> testListeners = new ArrayList<TestListener>();

    public void onTestFailure(TestCase test, Throwable cause) {
        for (TestListener listener : this.testListeners) {
            listener.onTestFailure(test, cause);
        }
    }

    public void onTestFinish(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onTestFinish(test);
        }
    }

    public void onTestSkipped(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onTestSkipped(test);
        }
    }

    public void onTestStart(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onTestStart(test);
        }
    }

    public void onTestSuccess(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onTestSuccess(test);
        }
    }

    @Override
    public void addTestListener(TestListener listener) {
        if (!this.testListeners.contains(listener)) {
            this.testListeners.add(listener);
        }
    }

    public List<TestListener> getTestListeners() {
        return this.testListeners;
    }
}

