/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.log;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.citrusframework.CitrusSettings;
import org.citrusframework.log.LogModifier;
import org.citrusframework.message.Message;

@FunctionalInterface
public interface LogMessageModifier
extends LogModifier {
    default public String maskBody(Message message) {
        return this.mask(message.getPayload(String.class).trim());
    }

    default public Map<String, Object> maskHeaders(Message message) {
        return message.getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            if (entry.getValue() == null) {
                return "";
            }
            String keyValuePair = String.format("%s=%s", entry.getKey(), entry.getValue());
            if (!keyValuePair.equals(this.mask(keyValuePair))) {
                return CitrusSettings.getLogMaskValue();
            }
            return entry.getValue();
        }, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
    }

    default public List<String> maskHeaderData(Message message) {
        if (message.getHeaderData() == null || message.getHeaderData().isEmpty()) {
            return Collections.emptyList();
        }
        return message.getHeaderData().stream().map(this::mask).collect(Collectors.toList());
    }
}

