/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.livevariable;

import java.util.List;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.nullaway.dataflow.analysis.BackwardTransferFunction;
import org.checkerframework.nullaway.dataflow.analysis.RegularTransferResult;
import org.checkerframework.nullaway.dataflow.analysis.TransferInput;
import org.checkerframework.nullaway.dataflow.analysis.TransferResult;
import org.checkerframework.nullaway.dataflow.analysis.UnusedAbstractValue;
import org.checkerframework.nullaway.dataflow.cfg.UnderlyingAST;
import org.checkerframework.nullaway.dataflow.cfg.node.AbstractNodeVisitor;
import org.checkerframework.nullaway.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.nullaway.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.nullaway.dataflow.cfg.node.Node;
import org.checkerframework.nullaway.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.nullaway.dataflow.cfg.node.ReturnNode;
import org.checkerframework.nullaway.dataflow.livevariable.LiveVarNode;
import org.checkerframework.nullaway.dataflow.livevariable.LiveVarStore;

public class LiveVarTransfer
extends AbstractNodeVisitor<TransferResult<UnusedAbstractValue, LiveVarStore>, TransferInput<UnusedAbstractValue, LiveVarStore>>
implements BackwardTransferFunction<UnusedAbstractValue, LiveVarStore> {
    @Override
    @SideEffectFree
    public LiveVarStore initialNormalExitStore(UnderlyingAST underlyingAST, List<ReturnNode> returnNodes) {
        return new LiveVarStore();
    }

    @Override
    public LiveVarStore initialExceptionalExitStore(UnderlyingAST underlyingAST) {
        return new LiveVarStore();
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, LiveVarStore> visitNode(Node n, TransferInput<UnusedAbstractValue, LiveVarStore> p) {
        return new RegularTransferResult<Object, LiveVarStore>(null, p.getRegularStore());
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, LiveVarStore> visitAssignment(AssignmentNode n, TransferInput<UnusedAbstractValue, LiveVarStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitAssignment(n, p);
        this.processLiveVarInAssignment(n.getTarget(), n.getExpression(), (LiveVarStore)transferResult.getRegularStore());
        return transferResult;
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, LiveVarStore> visitMethodInvocation(MethodInvocationNode n, TransferInput<UnusedAbstractValue, LiveVarStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitMethodInvocation(n, p);
        LiveVarStore store = (LiveVarStore)transferResult.getRegularStore();
        for (Node arg : n.getArguments()) {
            store.addUseInExpression(arg);
        }
        return transferResult;
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, LiveVarStore> visitObjectCreation(ObjectCreationNode n, TransferInput<UnusedAbstractValue, LiveVarStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitObjectCreation(n, p);
        LiveVarStore store = (LiveVarStore)transferResult.getRegularStore();
        for (Node arg : n.getArguments()) {
            store.addUseInExpression(arg);
        }
        return transferResult;
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, LiveVarStore> visitReturn(ReturnNode n, TransferInput<UnusedAbstractValue, LiveVarStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitReturn(n, p);
        Node result = n.getResult();
        if (result != null) {
            LiveVarStore store = (LiveVarStore)transferResult.getRegularStore();
            store.addUseInExpression(result);
        }
        return transferResult;
    }

    private void processLiveVarInAssignment(Node variable, Node expression, LiveVarStore store) {
        store.killLiveVar(new LiveVarNode(variable));
        store.addUseInExpression(expression);
    }
}

